import java.awt.*;

public class EnemyA extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_A;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 2;                          // ϋvx
    private static final double size = 6.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 40;

    private static Plate plate[];                             // \Platez
    private static final int pNum = 3;                        // \Plate

    private static final Color colorCL = new Color(0xd0d0ff); // \F
    private static final Color colorCF = new Color(0xa0a0d0); // \F
    private static final int styleC = Plate.LNFL;             // \X^C
    private static final double shapeC[][] = {                // `
        {  0.0, 2.0},
        {  6.0, 0.0},
        {  0.0,-2.0},
        {  0.0, 2.0},
    };
    private static final Color colorLL = new Color(0xa0a0ff); // \F
    private static final Color colorLF = new Color(0x8080d0); // \F
    private static final int styleL = Plate.LNFL;             // \X^C
    private static final double shapeL[][] = {                // `
        { -6.0, 8.0},
        {  4.0, 3.0},
        { -2.0, 3.0},
        { -6.0, 8.0},
    };
    private static final Color colorRL = new Color(0xa0a0ff); // \F
    private static final Color colorRF = new Color(0x8080d0); // \F
    private static final int styleR = Plate.LNFL;             // \X^C
    private static final double shapeR[][] = {                // `
        { -6.0, -8.0},
        {  4.0, -3.0},
        { -2.0, -3.0},
        { -6.0, -8.0},
    };

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        plate = new Plate[pNum];
        plate[0] = new Plate(colorCL, colorCF, styleC, shapeC);
        plate[1] = new Plate(colorRL, colorRF, styleR, shapeR);
        plate[2] = new Plate(colorLL, colorLF, styleL, shapeL);
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyA() {
        super(0.0, 0.0, size);

        cntr = 0;
    }
    EnemyA(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
    }
    EnemyA(
        int id,
        double posX,
        double posY,
        int th
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        eid = id;
        cntr = 0;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    // ʕ\
    public final void draw(
        Graphics g        // \ΏGraphics
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    // \Fwʕ\
    public final void draw(
        Graphics g,      // \ΏGraphics
        Color    col     // \F
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setTurret(
        int th
    ) {
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
    }
}
