import java.awt.*;

public class EnemyB extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_B;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 8;                          // ϋvx
    private static final double size = 7.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 60;

    private static Plate plate[];                             // \Platez
    private static final int pNum = 4;                        // \Plate

    private static final Color colorCL = new Color(0xe0e080); // \F
    private static final Color colorCF = new Color(0xd0d070); // \F
    private static final int styleC = Plate.LNFL;             // \X^C
    private static final double shapeC[][] = {                // `
        {  1.0, -3.0},
        {  7.0,  0.0},
        {  1.0,  3.0},
        {  1.0, -3.0},
    };
    private static final Color colorLL = new Color(0xd0d0d0); // \F
    private static final Color colorLF = new Color(0xa0a080); // \F
    private static final int styleL = Plate.LNFL;             // \X^C
    private static final double shapeL[][] = {                // `
        { -3.0,  8.0},
        { -5.0,  4.0},
        {  5.0,  4.0},
        {  4.0,  6.0},
        { -3.0,  8.0},
    };
    private static final Color colorRL = new Color(0xd0d0d0); // \F
    private static final Color colorRF = new Color(0xa0a080); // \F
    private static final int styleR = Plate.LNFL;             // \X^C
    private static final double shapeR[][] = {                // `
        { -3.0,  -8.0},
        { -5.0,  -4.0},
        {  5.0,  -4.0},
        {  4.0,  -6.0},
        { -3.0,  -8.0},
    };
    private static final Color colorTL = new Color(0xffc060); // \F
    private static final Color colorTF = new Color(0xe08040); // \F
    private static final int styleT = Plate.LNFL;             // \X^C
    private static final double shapeT[][] = {                // `
        {  -2.0, -2.0},
        {   6.0, -1.0},
        {   8.0,  0.0},
        {   6.0,  1.0},
        {  -2.0,  2.0},
        {  -2.0, -2.0},
    };

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;
    private int turretTh;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        plate = new Plate[pNum];
        plate[0] = new Plate(colorRL, colorRF, styleR, shapeR);
        plate[1] = new Plate(colorLL, colorLF, styleL, shapeL);
        plate[2] = new Plate(colorCL, colorCF, styleC, shapeC);
        plate[3] = new Plate(colorTL, colorTF, styleT, shapeT);
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyB() {
        super(0.0, 0.0, size);

        cntr = 0;
        turretTh = 90;
    }
    EnemyB(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
        turretTh = 90;
    }
    EnemyB(
        int id,
        double posX,
        double posY,
        int th
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        eid = id;
        cntr = 0;
        turretTh = 90;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    public final void setTurret(
        int th
    ) {
        turretTh = th;
    }

    // ʕ\
    public final void draw(
        Graphics g        // \ΏGraphics
    ) {
        plate[0].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[1].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[2].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[3].draw(g, getPosX(), getPosY(), turretTh, getScale(), getScale());
    }

    // \Fwʕ\
    public final void draw(
        Graphics g,      // \ΏGraphics
        Color    col     // \F
    ) {
        plate[0].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[1].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[2].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[3].draw(g, col, getPosX(), getPosY(), turretTh, getScale(), getScale());
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
        turretTh = 90;
    }
}
