import java.awt.*;

public class EnemyC extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_C;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 1;                          // ϋvx
    private static final double size = 7.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 100;

    private static final int pNum = 5;                       // \Plate
    private static Plate plate[];                            // \Platez

    private static final Color color1L = new Color(0xf0f0b0); // \F
    private static final Color color1F = new Color(0xc0c0b0); // \F
    private static final int style1 = Plate.LNFL;            // \X^C
    private static final double shape1[][] = {               // `
        {  1.0,  8.0},
        {  3.0,  8.0},
        {  8.0,  3.0},
        {  8.0,  1.0},
        {  1.0,  1.0},
        {  1.0,  8.0},
    };
    private static final Color color2L = new Color(0xf0f0b0); // \F
    private static final Color color2F = new Color(0xc0c0b0); // \F
    private static final int style2 = Plate.LNFL;            // \X^C
    private static final double shape2[][] = {               // `
        { -1.0,  8.0},
        { -3.0,  8.0},
        { -8.0,  3.0},
        { -8.0,  1.0},
        { -1.0,  1.0},
        { -1.0,  8.0},
    };
    private static final Color color3L = new Color(0xf0f0b0); // \F
    private static final Color color3F = new Color(0xc0c0b0); // \F
    private static final int style3 = Plate.LNFL;            // \X^C
    private static final double shape3[][] = {               // `
        {  1.0, -8.0},
        {  3.0, -8.0},
        {  8.0, -3.0},
        {  8.0, -1.0},
        {  1.0, -1.0},
        {  1.0, -8.0},
    };
    private static final Color color4L = new Color(0xf0f0b0); // \F
    private static final Color color4F = new Color(0xc0c0b0); // \F
    private static final int style4 = Plate.LNFL;            // \X^C
    private static final double shape4[][] = {               // `
        { -1.0, -8.0},
        { -3.0, -8.0},
        { -8.0, -3.0},
        { -8.0, -1.0},
        { -1.0, -1.0},
        { -1.0, -8.0},
    };
    private static final Color color5L = new Color(0xff4040); // \F
    private static final Color color5F = new Color(0xff4040); // \F
    private static final int style5 = Plate.FILL;            // \X^C
    private static final double shape5[][] = {               // `
        { -4.0, -4.0},
        {  4.0, -4.0},
        {  4.0,  4.0},
        { -4.0,  4.0},
        { -4.0, -4.0},
    };

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        plate = new Plate[pNum];
        plate[0] = new Plate(color5L, color5F, style5, shape5);
        plate[1] = new Plate(color1L, color1F, style1, shape1);
        plate[2] = new Plate(color2L, color2F, style2, shape2);
        plate[3] = new Plate(color3L, color3F, style3, shape3);
        plate[4] = new Plate(color4L, color4F, style4, shape4);
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyC() {
        super(0.0, 0.0, size);

        cntr = 0;
    }
    EnemyC(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
    }
    EnemyC(
        int id,
        double posX,
        double posY,
        int th
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        eid = id;
        cntr = 0;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    // ʕ\
    public final void draw(
        Graphics g        // \ΏGraphics
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    // \Fwʕ\
    public final void draw(
        Graphics g,      // \ΏGraphics
        Color    col     // \F
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setTurret(
        int th
    ) {
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
    }
}
