import java.awt.*;

final public class LargeFont {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final double width  = 18.0;
    private static final double height = 12.0;

    private static final int cellNum = 128;  // LargeFont
    private static Plate plate[][];          // eLargeFont\Platez

    private static final double shape[][][][] = {         // `
        // LargeFont:00-31
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},

        // LargeFont:32 " "
        {
            {
                {-8.0,  1.0},{-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  1.0},
                { 5.0,  1.0},{ 5.0,  3.0},{-6.0,  3.0},{-6.0,  1.0},
                {-8.0,  1.0},
            }
        },
        // LargeFont:33-45
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        // LargeFont:40 "("
        {
            {
                {-4.0, -2.0},{-4.0,  2.0},{-1.0,  5.0},{ 4.0,  5.0},
                { 1.0,  2.0},{ 1.0, -2.0},{ 4.0, -5.0},{-1.0, -5.0},
                {-4.0, -2.0},
            }
        },
        // LargeFont:41 ")"
        {
            {
                {-5.0, -5.0},{-2.0, -2.0},{-2.0,  2.0},{-5.0,  5.0},
                { 0.0,  5.0},{ 3.0,  2.0},{ 3.0, -2.0},{ 0.0, -5.0},
                {-5.0, -5.0},
            }
        },
        {{{}}},{{{}}},{{{}}},{{{}}},
        // LargeFont:46 "."
        {
            {
                {-3.0,  3.0},{-3.0,  5.0},{ 2.0,  5.0},{ 2.0,  3.0},
                {-3.0,  3.0},
            }
        },
        // LargeFont:47 "/"
        {
            {
                {-8.0,  5.0},{ 2.0, -5.0},{ 7.0, -5.0},{-3.0,  5.0},
                {-8.0,  5.0},
            }
        },
        // LargeFont:48 "0"
        {
            {
                {-6.0, -3.0},{-8.0, -1.0},{-8.0,  3.0},{-6.0,  5.0},
                { 5.0,  5.0},{ 7.0,  3.0},{ 7.0, -1.0},{ 5.0, -3.0},
                {-1.0, -3.0},{-1.0, -1.0},{ 2.0, -1.0},{ 2.0,  3.0},
                {-3.0,  3.0},{-3.0, -3.0},{-6.0, -3.0},
            }
        },
        // LargeFont:49 "1"
        {
            {
                {-3.0, -3.0},{-3.0,  5.0},{ 2.0,  5.0},{ 2.0, -5.0},
                {-1.0, -5.0},{-3.0, -3.0},
            }
        },
        // LargeFont:50 "2"
        {
            {
                {-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  3.0},{-3.0,  3.0},
                {-3.0,  1.0},{ 5.0,  1.0},{ 7.0, -1.0},{ 7.0, -3.0},
                { 5.0, -5.0},{-8.0, -5.0},{-8.0, -3.0},{ 2.0, -3.0},
                { 2.0, -1.0},{-6.0, -1.0},{-8.0,  1.0},{-8.0,  5.0},
            }
        },
        // LargeFont:51 "3"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{ 2.0, -3.0},{ 2.0, -1.0},
                {-6.0, -1.0},{-6.0,  1.0},{ 2.0,  1.0},{ 2.0,  3.0},
                {-8.0,  3.0},{-8.0,  5.0},{ 5.0,  5.0},{ 7.0,  3.0},
                { 7.0, -3.0},{ 5.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:52 "4"
        {
            {
                {-6.0, -5.0},{-8.0, -3.0},{-8.0,  2.0},{ 2.0,  2.0},
                { 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},{ 2.0, -5.0},
                { 2.0,  0.0},{-3.0,  0.0},{-3.0, -5.0},{-6.0, -5.0},
            }
        },
        // LargeFont:53 "5"
        {
            {
                {-8.0, -5.0},{-8.0,  1.0},{ 2.0,  1.0},{ 2.0,  3.0},
                {-8.0,  3.0},{-8.0,  5.0},{ 5.0,  5.0},{ 7.0,  3.0},
                { 7.0,  1.0},{ 5.0, -1.0},{-3.0, -1.0},{-3.0, -3.0},
                { 7.0, -3.0},{ 7.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:54 "6"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0,  1.0},{ 5.0, -1.0},{-1.0, -1.0},
                {-1.0,  1.0},{ 2.0,  1.0},{ 2.0,  3.0},{-3.0,  3.0},
                {-3.0, -3.0},{ 5.0, -3.0},{ 5.0, -5.0},{-6.0, -5.0},
                {-8.0, -3.0},
            }
        },
        // LargeFont:55 "7"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{ 2.0, -3.0},{ 2.0, -1.0},
                {-2.0, -1.0},{-4.0,  1.0},{-4.0,  5.0},{ 1.0,  5.0},
                { 1.0,  1.0},{ 5.0,  1.0},{ 7.0, -1.0},{ 7.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:56 "8"
        {
            {
                {-6.0, -5.0},{-8.0, -3.0},{-8.0, -2.0},{-6.0,  0.0},
                {-8.0,  2.0},{-8.0,  3.0},{-6.0,  5.0},{ 0.0,  5.0},
                { 0.0,  3.0},{-3.0,  3.0},{-3.0,  1.0},{ 2.0,  1.0},
                { 2.0,  5.0},{ 5.0,  5.0},{ 7.0,  3.0},{ 7.0,  2.0},
                { 5.0,  0.0},{ 7.0, -2.0},{ 7.0, -3.0},{ 5.0, -5.0},
                {-1.0, -5.0},{-1.0, -3.0},{ 2.0, -3.0},{ 2.0, -1.0},
                {-3.0, -1.0},{-3.0, -5.0},{-6.0, -5.0}
            }
        },
        // LargeFont:57 "9"
        {
            {
                {-8.0, -3.0},{-8.0, -1.0},{-6.0,  1.0},{ 0.0,  1.0},
                { 0.0, -1.0},{-3.0, -1.0},{-3.0, -3.0},{ 2.0, -3.0},
                { 2.0,  3.0},{-6.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -3.0},{ 5.0, -5.0},{-6.0, -5.0},
                {-8.0, -3.0},
            }
        },
        // LargeFont:58 ":"
        {
            {
                {-3.0, -4.0},{-3.0, -1.0},{-2.0, -1.0},{-2.0,  1.0},
                {-3.0,  1.0},{-3.0,  4.0},{ 2.0,  4.0},{ 2.0,  1.0},
                { 0.0,  1.0},{ 0.0, -1.0},{ 2.0, -1.0},{ 2.0, -4.0},
                {-3.0, -4.0},
            }
        },
        // LargeFont:59-64
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        // LargeFont:65 "A"
        {
            {
                {-8.0, -3.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  1.0},{-1.0,  1.0},{-1.0,  3.0},
                { 2.0,  3.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -3.0},
                { 5.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:66 "B"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 0.0,  5.0},{ 0.0,  3.0},
                {-3.0,  3.0},{-3.0,  1.0},{ 2.0,  1.0},{ 2.0,  5.0},
                { 5.0,  5.0},{ 7.0,  3.0},{ 7.0,  2.0},{ 5.0,  0.0},
                { 7.0, -2.0},{ 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},
                {-1.0, -3.0},{ 2.0, -3.0},{ 2.0, -1.0},{-3.0, -1.0},
                {-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:67 "C"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 7.0,  5.0},
                { 7.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 7.0, -3.0},
                { 7.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:68 "D"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 5.0,  5.0},{ 7.0,  3.0},
                { 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},{-1.0, -3.0},
                { 2.0, -3.0},{ 2.0,  3.0},{-3.0,  3.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:69 "E"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  3.0},
                {-3.0,  3.0},{-3.0,  1.0},{ 5.0,  1.0},{ 5.0, -1.0},
                {-3.0, -1.0},{-3.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:70 "F"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  1.0},
                { 5.0,  1.0},{ 5.0, -1.0},{-3.0, -1.0},{-3.0, -3.0},
                { 7.0, -3.0},{ 7.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:71 "G"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 7.0,  5.0},
                { 7.0, -1.0},{ 0.0, -1.0},{ 0.0,  1.0},{ 2.0,  1.0},
                { 2.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 7.0, -3.0},
                { 7.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:72 "H"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  1.0},
                { 2.0,  1.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -1.0},{-3.0, -1.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:73 "I"
        {
            {
                {-5.0, -5.0},{-5.0, -3.0},{-3.0, -3.0},{-3.0,  3.0},
                {-5.0,  3.0},{-5.0,  5.0},{ 4.0,  5.0},{ 4.0,  3.0},
                { 2.0,  3.0},{ 2.0, -3.0},{ 4.0, -3.0},{ 4.0, -5.0},
                {-5.0, -5.0},
            }
        },
        // LargeFont:74 "J"
        {
            {
                { 2.0, -5.0},{ 2.0,  3.0},{-3.0,  3.0},{-3.0,  1.0},
                {-8.0,  1.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -5.0},{ 2.0, -5.0},
            }
        },
        // LargeFont:75 "K"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  0.0},
                { 2.0,  5.0},{ 7.0,  5.0},{ 2.0,  0.0},{ 7.0, -5.0},
                { 2.0, -5.0},{-3.0,  0.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:76 "L"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  3.0},
                {-3.0,  3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:77 "M"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -2.0},
                {-1.0,  0.0},{ 0.0,  0.0},{ 2.0, -2.0},{ 2.0,  5.0},
                { 7.0,  5.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 0.0, -3.0},
                {-1.0, -3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:78 "N"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -1.0},
                { 2.0,  4.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0,  1.0},{-3.0, -4.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:79 "O"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},
                {-1.0, -3.0},{ 2.0, -3.0},{ 2.0,  3.0},{-3.0,  3.0},
                {-3.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:80 "P"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  1.0},{-1.0,  1.0},{-1.0,  3.0},
                { 5.0,  3.0},{ 7.0,  1.0},{ 7.0, -3.0},{ 5.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:81 "Q"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 1.0,  5.0},
                {-1.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 2.0, -3.0},
                { 2.0,  1.0},{ 0.0,  1.0},{ 4.0,  5.0},{ 7.0,  5.0},
                { 5.0,  3.0},{ 7.0,  1.0},{ 7.0, -3.0},{ 5.0, -5.0},
                {-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:82 "R"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  0.0},{-1.0,  0.0},{-1.0,  2.0},
                { 2.0,  5.0},{ 7.0,  5.0},{ 4.0,  2.0},{ 5.0,  2.0},
                { 7.0,  0.0},{ 7.0, -3.0},{ 5.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:83 "S"
        {
            {
                {-8.0, -3.0},{-8.0, -1.0},{-6.0,  1.0},{ 2.0,  1.0},
                { 2.0,  3.0},{-8.0,  3.0},{-8.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0,  1.0},{ 5.0, -1.0},{-3.0, -1.0},
                {-3.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},{-6.0, -5.0},
                {-8.0, -3.0},
            }
        },
        // LargeFont:84 "T"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{-3.0, -3.0},{-3.0,  5.0},
                { 2.0,  5.0},{ 2.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:85 "U"
        {
            {
                {-8.0, -5.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 2.0,  3.0},
                {-3.0,  3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:86 "V"
        {
            {
                {-8.0, -5.0},{-8.0,  0.0},{-3.0,  5.0},{ 2.0,  5.0},
                { 7.0,  0.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 2.0,  0.0},
                { 0.0,  2.0},{-1.0,  2.0},{-3.0,  0.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:87 "W"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-1.0,  3.0},
                { 0.0,  3.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0,  2.0},{ 0.0,  0.0},{-1.0,  0.0},
                {-3.0,  2.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:88 "X"
        {
            {
                {-8.0, -5.0},{-8.0, -4.0},{-4.0,  0.0},{-8.0,  4.0},
                {-8.0,  5.0},{-3.0,  5.0},{-3.0,  4.0},{-1.0,  2.0},
                { 0.0,  2.0},{ 2.0,  4.0},{ 2.0,  5.0},{ 7.0,  5.0},
                { 7.0,  4.0},{ 3.0,  0.0},{ 7.0, -4.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -4.0},{ 0.0, -2.0},{-1.0, -2.0},
                {-3.0, -4.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:89 "Y"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{-3.0,  2.0},{-3.0,  5.0},
                { 2.0,  5.0},{ 2.0,  2.0},{ 7.0, -3.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -3.0},{ 0.0, -1.0},{-1.0, -1.0},
                {-3.0, -3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:90 "Z"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{ 2.0, -3.0},{ 0.0, -1.0},
                {-4.0, -1.0},{-8.0,  3.0},{-8.0,  5.0},{ 7.0,  5.0},
                { 7.0,  3.0},{-3.0,  3.0},{-1.0,  1.0},{ 3.0,  1.0},
                { 7.0, -3.0},{ 7.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:91-96
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
        // LargeFont:97 "a"
        {
            {
                {-8.0, -3.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  1.0},{-1.0,  1.0},{-1.0,  3.0},
                { 2.0,  3.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -3.0},
                { 5.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:98 "b"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 0.0,  5.0},{ 0.0,  3.0},
                {-3.0,  3.0},{-3.0,  1.0},{ 2.0,  1.0},{ 2.0,  5.0},
                { 5.0,  5.0},{ 7.0,  3.0},{ 7.0,  2.0},{ 5.0,  0.0},
                { 7.0, -2.0},{ 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},
                {-1.0, -3.0},{ 2.0, -3.0},{ 2.0, -1.0},{-3.0, -1.0},
                {-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:99 "c"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 7.0,  5.0},
                { 7.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 7.0, -3.0},
                { 7.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:100 "d"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 5.0,  5.0},{ 7.0,  3.0},
                { 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},{-1.0, -3.0},
                { 2.0, -3.0},{ 2.0,  3.0},{-3.0,  3.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:101 "e"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  3.0},
                {-3.0,  3.0},{-3.0,  1.0},{ 5.0,  1.0},{ 5.0, -1.0},
                {-3.0, -1.0},{-3.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:102 "f"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  1.0},
                { 5.0,  1.0},{ 5.0, -1.0},{-3.0, -1.0},{-3.0, -3.0},
                { 7.0, -3.0},{ 7.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:103 "g"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 7.0,  5.0},
                { 7.0, -1.0},{ 0.0, -1.0},{ 0.0,  1.0},{ 2.0,  1.0},
                { 2.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 7.0, -3.0},
                { 7.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:104 "h"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  1.0},
                { 2.0,  1.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -1.0},{-3.0, -1.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:105 "i"
        {
            {
                {-5.0, -5.0},{-5.0, -3.0},{-3.0, -3.0},{-3.0,  3.0},
                {-5.0,  3.0},{-5.0,  5.0},{ 4.0,  5.0},{ 4.0,  3.0},
                { 2.0,  3.0},{ 2.0, -3.0},{ 4.0, -3.0},{ 4.0, -5.0},
                {-5.0, -5.0},
            }
        },
        // LargeFont:106 "j"
        {
            {
                { 2.0, -5.0},{ 2.0,  3.0},{-3.0,  3.0},{-3.0,  1.0},
                {-8.0,  1.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -5.0},{ 2.0, -5.0},
            }
        },
        // LargeFont:107 "k"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0,  0.0},
                { 2.0,  5.0},{ 7.0,  5.0},{ 2.0,  0.0},{ 7.0, -5.0},
                { 2.0, -5.0},{-3.0,  0.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:108 "l"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{ 7.0,  5.0},{ 7.0,  3.0},
                {-3.0,  3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:109 "m"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -2.0},
                {-1.0,  0.0},{ 0.0,  0.0},{ 2.0, -2.0},{ 2.0,  5.0},
                { 7.0,  5.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 0.0, -3.0},
                {-1.0, -3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:110 "n"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -1.0},
                { 2.0,  4.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0,  1.0},{-3.0, -4.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:111 "o"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -3.0},{ 5.0, -5.0},{-1.0, -5.0},
                {-1.0, -3.0},{ 2.0, -3.0},{ 2.0,  3.0},{-3.0,  3.0},
                {-3.0, -5.0},{-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:112 "p"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  1.0},{-1.0,  1.0},{-1.0,  3.0},
                { 5.0,  3.0},{ 7.0,  1.0},{ 7.0, -3.0},{ 5.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:113 "q"
        {
            {
                {-8.0, -3.0},{-8.0,  3.0},{-6.0,  5.0},{ 1.0,  5.0},
                {-1.0,  3.0},{-3.0,  3.0},{-3.0, -3.0},{ 2.0, -3.0},
                { 2.0,  1.0},{ 0.0,  1.0},{ 4.0,  5.0},{ 7.0,  5.0},
                { 5.0,  3.0},{ 7.0,  1.0},{ 7.0, -3.0},{ 5.0, -5.0},
                {-6.0, -5.0},{-8.0, -3.0},
            }
        },
        // LargeFont:114 "r"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-3.0, -3.0},
                { 2.0, -3.0},{ 2.0,  0.0},{-1.0,  0.0},{-1.0,  2.0},
                { 2.0,  5.0},{ 7.0,  5.0},{ 4.0,  2.0},{ 5.0,  2.0},
                { 7.0,  0.0},{ 7.0, -3.0},{ 5.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:115 "s"
        {
            {
                {-8.0, -3.0},{-8.0, -1.0},{-6.0,  1.0},{ 2.0,  1.0},
                { 2.0,  3.0},{-8.0,  3.0},{-8.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0,  1.0},{ 5.0, -1.0},{-3.0, -1.0},
                {-3.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},{-6.0, -5.0},
                {-8.0, -3.0},
            }
        },
        // LargeFont:116 "t"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{-3.0, -3.0},{-3.0,  5.0},
                { 2.0,  5.0},{ 2.0, -3.0},{ 7.0, -3.0},{ 7.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:117 "u"
        {
            {
                {-8.0, -5.0},{-8.0,  3.0},{-6.0,  5.0},{ 5.0,  5.0},
                { 7.0,  3.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 2.0,  3.0},
                {-3.0,  3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:118 "v"
        {
            {
                {-8.0, -5.0},{-8.0,  0.0},{-3.0,  5.0},{ 2.0,  5.0},
                { 7.0,  0.0},{ 7.0, -5.0},{ 2.0, -5.0},{ 2.0,  0.0},
                { 0.0,  2.0},{-1.0,  2.0},{-3.0,  0.0},{-3.0, -5.0},
                {-8.0, -5.0},
            }
        },
        // LargeFont:119 "w"
        {
            {
                {-8.0, -5.0},{-8.0,  5.0},{-3.0,  5.0},{-1.0,  3.0},
                { 0.0,  3.0},{ 2.0,  5.0},{ 7.0,  5.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0,  2.0},{ 0.0,  0.0},{-1.0,  0.0},
                {-3.0,  2.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:120 "x"
        {
            {
                {-8.0, -5.0},{-8.0, -4.0},{-4.0,  0.0},{-8.0,  4.0},
                {-8.0,  5.0},{-3.0,  5.0},{-3.0,  4.0},{-1.0,  2.0},
                { 0.0,  2.0},{ 2.0,  4.0},{ 2.0,  5.0},{ 7.0,  5.0},
                { 7.0,  4.0},{ 3.0,  0.0},{ 7.0, -4.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -4.0},{ 0.0, -2.0},{-1.0, -2.0},
                {-3.0, -4.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:121 "y"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{-3.0,  2.0},{-3.0,  5.0},
                { 2.0,  5.0},{ 2.0,  2.0},{ 7.0, -3.0},{ 7.0, -5.0},
                { 2.0, -5.0},{ 2.0, -3.0},{ 0.0, -1.0},{-1.0, -1.0},
                {-3.0, -3.0},{-3.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:122 "z"
        {
            {
                {-8.0, -5.0},{-8.0, -3.0},{ 2.0, -3.0},{ 0.0, -1.0},
                {-4.0, -1.0},{-8.0,  3.0},{-8.0,  5.0},{ 7.0,  5.0},
                { 7.0,  3.0},{-3.0,  3.0},{-1.0,  1.0},{ 3.0,  1.0},
                { 7.0, -3.0},{ 7.0, -5.0},{-8.0, -5.0},
            }
        },
        // LargeFont:123-127
        {{{}}},{{{}}},{{{}}},{{{}}},{{{}}},{{{}}},
    };

    //========================================================================
    // ÓI
    //========================================================================
    static {
        Color chColLn = new Color(0xffffff);
        Color chColFl = new Color(0x000000);
        int chStyle = Plate.LNFL;

        plate = new Plate[cellNum][];
        for(int i=32; i<=122; i++) {
            plate[i]    = new Plate[1];
            plate[i][0] = new Plate(chColLn, chColFl, chStyle, shape[i][0]);
        }
    }

    //========================================================================
    // RXgN^
    //========================================================================

    //========================================================================
    // Method
    //========================================================================
    public static final double getHeight() {
        return height;
    }

    public static final double getWidth() {
        return width;
    }

    // ʕ\
    public static final void draw(
        int idx,
        Graphics g,       // \ΏGraphics
        double posx,
        double posy,
        int vec,
        double scX,
        double scY
    ) {
        if(idx != ' ') {
            for(int i=0; i<plate[idx].length; i++) {
                plate[idx][i].draw(g, posx, posy, vec, scX, scY);
            }
        }
    }

    // ʕ\
    public static final void draw(
        int idx,
        Graphics g,       // \ΏGraphics
        double posx,
        double posy
    ) {
        draw(idx, g, posx, posy, 0, 1.0, 1.0);
    }

    // \Fwʕ\
    public static final void draw(
        int idx,
        Graphics g,       // \ΏGraphics
        Color col1,
        Color col2,
        double posx,
        double posy,
        int vec,
        double scX,
        double scY
    ) {
        if(idx != ' ') {
            for(int i=0; i<plate[idx].length; i++) {
                plate[idx][i].draw(g, col1, col2, posx, posy, vec, scX, scY);
            }
        }
    }
}
