//============================================================================
//  wvZClass
//============================================================================
//  method:
//  e[u
//      public static final void init();
//
//  sin֐lԋp
//      public static final double sin(int deg);
//
//  cos֐lԋp
//      public static final double cos(int deg);
//
//  Q_ԕʕԋp
//      public static final int getBrg(double x1, double y1,
//                                     double x2, double y2)
//
//============================================================================
import java.lang.*;

final public class MyMath {

    //========================================================================
    // Op֐e[u
    //========================================================================
    private static double sinTbl[];
    private static double cosTbl[];
    private static int atanTbl[];

    //========================================================================
    // 萔`
    //========================================================================
    static final double D2R = Math.PI / 180.0;  // Degree/RadianϊW
    static final int    DEG = 360;
    static final int    ATAN = 100;             // atan2̐x

    //========================================================================
    // ÓI
    //========================================================================
    static {
        sinTbl  = new double[DEG];
        cosTbl  = new double[DEG];
        atanTbl = new int[ATAN];
        for(int deg=0; deg<DEG; deg++) {
            sinTbl[deg] = Math.sin((double)deg * D2R);
            cosTbl[deg] = Math.cos((double)deg * D2R);
        }
        for(int at=0; at<ATAN; at++) {
            atanTbl[at] = (int)(Math.atan((double)at * 0.01) / D2R);
        }
    }

    //========================================================================
    // sin֐
    //========================================================================
    public static final double sin(
        int deg         // ͒l[degree]
    ) {
        return sinTbl[regDeg(deg)];
    }

    //========================================================================
    // cos֐
    //========================================================================
    public static final double cos(
        int deg         // ͒l[degree]
    ) {
        return cosTbl[regDeg(deg)];
    }

    //========================================================================
    // DEGREEPʌnK
    //========================================================================
    public static final int regDeg(
        int deg
    ) {
        int result;

        while(deg >= DEG) {
            deg -= DEG;
        }
        while(deg < 0) {
            deg += DEG;
        }

        result = deg;

        return result;
    }

    //========================================================================
    // sqrt֐
    //========================================================================
    public static final double sqrt(
        double num      // ͒l
    ) {
        return Math.sqrt(num);
    }

    //========================================================================
    // Βl֐
    //========================================================================
    public static final double abs(
        double var
    ) {
        if(var < 0) {
            return -var;
        } else {
            return var;
        }
    }

    //========================================================================
    // ֐
    //========================================================================
    public static final int iRnd(int range) {
        return (int)(Math.random()*range);
    }

    //========================================================================
    // ֐
    //========================================================================
    public static final double fRnd(double range) {
        return Math.random()*range;
    }

    public static final int iPow(int a, int b) {
        int result;

        result = 1;
        if(b > 0) {
            for(int i=0; i<b; i++) {
                result = result*a;
            }
        }
        return result;
    }

    //========================================================================
    // QʊԂ̐p
    //========================================================================
    public static final int getDir(
        int dir1,
        int dir2
    ) {
        int dir;

        dir = dir2 - dir1;

        return regDeg(dir);
    }

    //========================================================================
    // Q_ԋ擾
    //========================================================================
    public static final double getDist(
        double x1,
        double y1,
        double x2,
        double y2
    ) {
        return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
    }

    //========================================================================
    // Q_ԕʎ擾
    //========================================================================
    public static final int getBrg(
        double x1,
        double y1,
        double x2,
        double y2
    ) {
        double dx, dy;
        int result = 0;
        int at;
        int deg0;
        boolean rvs;

        dx = x2 - x1;
        dy = y2 - y1;

        // Pی
        if((dx >= 0) && (dy >= 0)) {
            if(Math.abs(dy) > Math.abs(dx)) {
                at = (int)((dx / dy) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 89 - deg0;
            } else {
                at = (int)((dy / dx) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = deg0;
            }
        }
        // Qی
        if((dx < 0) && (dy >= 0)) {
            if(Math.abs(dy) > Math.abs(dx)) {
                at = (int)((-dx / dy) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 90 + deg0;
            } else {
                at = (int)((dy / -dx) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 179 - deg0;
            }
        }
        // Rی
        if((dx < 0) && (dy < 0)) {
            if(Math.abs(dy) > Math.abs(dx)) {
                at = (int)((-dx / -dy) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 269 - deg0;
            } else {
                at = (int)((-dy / -dx) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 180 + deg0;
            }
        }
        // Sی
        if((dx >= 0) && (dy < 0)) {
            if(Math.abs(dy) > Math.abs(dx)) {
                at = (int)((dx / -dy) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 270 + deg0;
            } else {
                at = (int)((-dy / dx) * 100) - 1;
                if(at < 0) {
                    at = 0;
                }
if((at < 0) || (at >= 100)) {
System.out.println("at:"+at+",x1:"+x1+",y1:"+y1+",x2:"+x2+",y2:"+y2);
}
                deg0 = regDeg(atanTbl[at]);
                result = 359 - deg0;
            }
        }

        return result;
    }
}
