import java.awt.*;

public class Plate {

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int    ptNum;        // _
    private Color  lineCol;      // \F
    private Color  fillCol;      // hԂF
    private int    style;        // \X^C
    private double shape[][];    // `
    private int    dispX[];      // \pW
    private int    dispY[];      // \pW

    public static final int LINE = 0;   // `X^C:
    public static final int FILL = 1;   // `X^C:hԂ
    public static final int LNFL = 2;   // `X^C:{hԂ

    //========================================================================
    // RXgN^
    //========================================================================
    public Plate(
        Color  lnCol,  // LINE\F
        Color  flCol,  // FILL\F
        int    style,  // \X^C
        double sh[][]  // `
    ) {
        this.lineCol = lnCol;
        this.fillCol = flCol;
        this.style = style;
        this.ptNum = sh.length;
        this.shape = sh;

        dispX = new int[ptNum];
        dispY = new int[ptNum];
    }

    public Plate(
        Color  col,    // \F
        int    style,  // \X^C
        double sh[][]  // `
    ) {
        this(col, col, style, sh);
    }

    //========================================================================
    // Method
    //========================================================================
    // \Fw`揈
    public final void draw(
        Graphics g,     // \ΏGraphics
        Color    lnCol, // LINE\F
        Color    flCol, // FILL\F
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[
        double scY      // \XP[
    ) {
        double tmpSin = MyMath.sin(vec); // sinl
        double tmpCos = MyMath.cos(vec); // cosl

        // `WvZ
        for(int i=0; i<ptNum; i++) {
            dispX[i] = (int)(x + (shape[i][0]*tmpCos*scX -
                                  shape[i][1]*tmpSin*scY));
            dispY[i] = (int)(y + (shape[i][0]*tmpSin*scX +
                                  shape[i][1]*tmpCos*scY));
        }

        // `揈
        switch (style) {
            case LINE:
                // `X^C:
                // drawPolyline̋Javão[WɂĈႤ
                // 1.1 : I_`悵Ȃ
                // 1.3 : I_`悷
                // ̂ŁALINEX^ĈƂdrawLinegpĕ`
                g.setColor(lnCol);
//                g.drawPolyline(dispX, dispY, ptNum);
                for(int i=1; i<ptNum; i++) {
                    g.drawLine(dispX[i-1], dispY[i-1], dispX[i], dispY[i]);
                }
                break;

            case FILL:
                // `X^C:hԂ
                g.setColor(flCol);
                g.fillPolygon(dispX, dispY, ptNum);
                break;

            case LNFL:
                // `X^C:{hԂ
                g.setColor(flCol);
                g.fillPolygon(dispX, dispY, ptNum);

                g.setColor(lnCol);
                g.drawPolyline(dispX, dispY, ptNum);
                break;

            default:
                break;
        }
    }

    // PF\Fw`
    public final void draw(
        Graphics g,     // \ΏGraphics
        Color col,      // \F
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[X
        double scY      // \XP[Y
    ) {
//        draw(g, col, rdcCol(col), x, y, vec, scX, scY);
        draw(g, col, col, x, y, vec, scX, scY);
    }

    // Fw`
    public final void draw(
        Graphics g,     // \ΏGraphics
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[X
        double scY      // \XP[Y
    ) {
        draw(g, this.lineCol, this.fillCol, x, y, vec, scX, scY);
    }

    // Fϊ(PxƂ)
    private final Color rdcCol(
        Color col       // F
    ) {
        Color res;
        int colR;
        int colG;
        int colB;

        colR = col.getRed();
        colG = col.getGreen();
        colB = col.getBlue();

        colR = colR / 2;
        colG = colG / 2;
        colB = colB / 2;

        res = new Color((colR << 16) + (colG << 8) + colB);

        return res;
    }
}
