/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class Plate {
    private int ptNum;
    private Color lineCol;
    private Color fillCol;
    private int style;
    private double[][] shape;
    private int[] vect;
    private int[] dispX;
    private int[] dispY;
    private int[] dispVect;
    private Color[] dispColTbl;
    public static final int LINE = 0;
    public static final int FILL = 1;
    public static final int LNFL = 2;
    public static final int FL3D = 3;

    public Plate(Color color, int n, double[][] dArray) {
        this(color, color, n, dArray);
    }

    public Plate(Color color, Color color2, int n, double[][] dArray) {
        this.lineCol = color;
        this.fillCol = color2;
        this.style = n;
        this.ptNum = dArray.length;
        this.shape = dArray;
        this.dispX = new int[this.ptNum];
        this.dispY = new int[this.ptNum];
        if (n == 3) {
            this.dispColTbl = new Color[19];
            int n2 = 0;
            while (n2 < 19) {
                this.dispColTbl[n2] = this.gainCol2(color2, (9 - n2) * 9);
                ++n2;
            }
            this.dispVect = new int[this.ptNum - 1];
            this.vect = new int[this.ptNum - 1];
            int n3 = 0;
            while (n3 < this.ptNum - 1) {
                double d;
                double d2 = 0.1;
                int n4 = MyMath.getBrg(dArray[n3][0], dArray[n3][1], dArray[n3 + 1][0], dArray[n3 + 1][1]);
                int n5 = n4 - 90;
                int n6 = n4 + 90;
                double d3 = (dArray[n3][0] + dArray[n3 + 1][0]) * 0.5;
                double d4 = (dArray[n3][1] + dArray[n3 + 1][1]) * 0.5;
                double d5 = d3 + MyMath.cos(n5) * d2;
                this.vect[n3] = this.isInside(dArray, d5, d = d4 + MyMath.sin(n5) * d2) ? n6 : n5;
                ++n3;
            }
        }
    }

    private final boolean isInside(double[][] dArray, double d, double d2) {
        int n = dArray.length;
        double d3 = 10000.0;
        double d4 = d2 + 1.0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        n2 = 0;
        while (n2 < n - 1) {
            if (MyMath.isIntersect(dArray[n2][0], dArray[n2][1], dArray[n2 + 1][0], dArray[n2 + 1][1], d, d2, d3, d4)) {
                ++n3;
            }
            ++n2;
        }
        return n3 & true;
    }

    public final void draw(Graphics graphics, Color color, Color color2, double d, double d2, int n, double d3, double d4) {
        int n2;
        double d5 = MyMath.sin(n);
        double d6 = MyMath.cos(n);
        int n3 = 0;
        while (n3 < this.ptNum) {
            this.dispX[n3] = (int)(d + (this.shape[n3][0] * d6 * d3 - this.shape[n3][1] * d5 * d4));
            this.dispY[n3] = (int)(d2 + (this.shape[n3][0] * d5 * d3 + this.shape[n3][1] * d6 * d4));
            ++n3;
        }
        if (this.style == 3) {
            n2 = 0;
            while (n2 < this.ptNum - 1) {
                this.dispVect[n2] = MyMath.regDeg(this.vect[n2] + n);
                ++n2;
            }
        }
        switch (this.style) {
            case 0: {
                graphics.setColor(color);
                n2 = 1;
                while (n2 < this.ptNum) {
                    graphics.drawLine(this.dispX[n2 - 1], this.dispY[n2 - 1], this.dispX[n2], this.dispY[n2]);
                    ++n2;
                }
                break;
            }
            case 1: {
                graphics.setColor(color2);
                graphics.fillPolygon(this.dispX, this.dispY, this.ptNum);
                break;
            }
            case 2: {
                graphics.setColor(color2);
                graphics.fillPolygon(this.dispX, this.dispY, this.ptNum);
                graphics.setColor(color);
                graphics.drawPolyline(this.dispX, this.dispY, this.ptNum);
                break;
            }
            case 3: {
                graphics.setColor(color2);
                graphics.fillPolygon(this.dispX, this.dispY, this.ptNum);
                int n4 = 0;
                while (n4 < this.ptNum - 1) {
                    if (this.dispVect[n4] < 45) {
                        int n5 = n4;
                        this.dispVect[n5] = this.dispVect[n5] + 360;
                    }
                    int n6 = Math.abs(this.dispVect[n4] - 225);
                    graphics.setColor(this.dispColTbl[n6 / 10]);
                    graphics.drawLine(this.dispX[n4], this.dispY[n4], this.dispX[n4 + 1], this.dispY[n4 + 1]);
                    ++n4;
                }
                break;
            }
        }
    }

    public final void draw(Graphics graphics, Color color, double d, double d2, int n, double d3, double d4) {
        this.draw(graphics, color, color, d, d2, n, d3, d4);
    }

    public final void draw(Graphics graphics, double d, double d2, int n, double d3, double d4) {
        this.draw(graphics, this.lineCol, this.fillCol, d, d2, n, d3, d4);
    }

    private final Color gainCol(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if ((n = (int)((double)n * d)) > 255) {
            n = 255;
        }
        if ((n2 = (int)((double)n2 * d)) > 255) {
            n2 = 255;
        }
        if ((n3 = (int)((double)n3 * d)) > 255) {
            n3 = 255;
        }
        Color color2 = new Color((n << 16) + (n2 << 8) + n3);
        return color2;
    }

    private final Color gainCol2(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        if ((n2 += n) > 255) {
            n2 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n3 += n) > 255) {
            n3 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n4 += n) > 255) {
            n4 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        Color color2 = new Color((n2 << 16) + (n3 << 8) + n4);
        return color2;
    }

    private final Color rdcCol(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        Color color2 = new Color(((n /= 2) << 16) + ((n2 /= 2) << 8) + (n3 /= 2));
        return color2;
    }
}

