import java.awt.*;

public class EnemyD extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_D;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 12;                         // ϋvx
    private static final double size = 9.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 240;

    private static Plate plate[];                             // \Platez
    private static final int pNum = 6;                        // \Plate

    private static final Color color1L = new Color(0xb0b0a0); // \F
    private static final Color color1F = new Color(0x808060); // \F
    private static final int style1 = Plate.FL3D;             // \X^C
    private static final double shape1[][] = {                // `
        {  -9.0, -6.0},
        {  -6.0, -9.0},
        {  -1.0, -9.0},
        {  -1.0, -1.0},
        {  -9.0, -1.0},
        {  -9.0, -6.0},
    };
    private static final int style2 = Plate.FL3D;             // \X^C
    private static final double shape2[][] = {                // `
        {   9.0, -6.0},
        {   6.0, -9.0},
        {   1.0, -9.0},
        {   1.0, -1.0},
        {   9.0, -1.0},
        {   9.0, -6.0},
    };
    private static final int style3 = Plate.FL3D;             // \X^C
    private static final double shape3[][] = {                // `
        {  -9.0,  6.0},
        {  -6.0,  9.0},
        {  -1.0,  9.0},
        {  -1.0,  1.0},
        {  -9.0,  1.0},
        {  -9.0,  6.0},
    };
    private static final int style4 = Plate.FL3D;             // \X^C
    private static final double shape4[][] = {                // `
        {   9.0,  6.0},
        {   6.0,  9.0},
        {   1.0,  9.0},
        {   1.0,  1.0},
        {   9.0,  1.0},
        {   9.0,  6.0},
    };
    private static final Color color5L = new Color(0xd0d0d0); // \F
    private static final Color color5F = new Color(0xb0b0b0); // \F
    private static final int style5 = Plate.FL3D;             // \X^C
    private static final double shape5[][] = {                // `
        { -6.0, -3.0},
        { -3.0, -6.0},
        {  3.0, -6.0},
        {  6.0, -3.0},
        {  6.0,  3.0},
        {  3.0,  6.0},
        { -3.0,  6.0},
        { -6.0,  3.0},
        { -6.0, -3.0},
    };
    private static final Color colorTL = new Color(0xffffff); // \F
    private static final Color colorTF = new Color(0xf0c080); // \F
    private static final int styleT = Plate.FL3D;             // \X^C
    private static final double shapeT[][] = {                // `
        {  -4.0,  0.0},
        {  -2.0, -3.0},
        {   8.0, -2.0},
        {  10.0,  0.0},
        {   8.0,  2.0},
        {  -2.0,  3.0},
        {  -4.0,  0.0},
    };

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;
    private int turretTh;
    private int dir;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        plate = new Plate[pNum];
        plate[0] = new Plate(color1L, color1F, style1, shape1);
        plate[1] = new Plate(color1L, color1F, style2, shape2);
        plate[2] = new Plate(color1L, color1F, style3, shape3);
        plate[3] = new Plate(color1L, color1F, style4, shape4);
        plate[4] = new Plate(color5L, color5F, style5, shape5);
        plate[5] = new Plate(colorTL, colorTF, styleT, shapeT);
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyD() {
        super(0.0, 0.0, size);

        cntr = 0;
        turretTh = 90;
    }
    EnemyD(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
        turretTh = 90;
    }
    EnemyD(
        int id,
        double posX,
        double posY,
        int th
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        eid = id;
        cntr = 0;
        turretTh = 90;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    public final void setTurret(
        int th
    ) {
        turretTh = th;
    }

    // ʕ\
    public final void draw(
        Graphics g        // \ΏGraphics
    ) {
        plate[0].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[1].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[2].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[3].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[4].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[5].draw(g, getPosX(), getPosY(), turretTh, getScale(), getScale());
    }

    // \Fwʕ\
    public final void draw(
        Graphics g,      // \ΏGraphics
        Color    col     // \F
    ) {
        plate[0].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[1].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[2].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[3].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[4].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        plate[5].draw(g, col, getPosX(), getPosY(), turretTh, getScale(), getScale());
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setDir(int d) {
        dir = d;
    }

    public final int getDir() {
        return dir;
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
        turretTh = 90;
    }
}
