import java.awt.*;

public class Plate {

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int    ptNum;        // _
    private Color  lineCol;      // \F
    private Color  fillCol;      // hԂF
    private int    style;        // \X^C
    private double shape[][];    // `
    private int    vect[];       // @xNg

    private int    dispX[];      // \pW
    private int    dispY[];      // \pW
    private int    dispVect[];   // \p@xNg
    private Color  dispColTbl[]; // Ae\Fe[u

    public static final int LINE = 0;   // `X^C:
    public static final int FILL = 1;   // `X^C:hԂ
    public static final int LNFL = 2;   // `X^C:{hԂ
    public static final int FL3D = 3;   // `X^C:hԂ{Ae

    //========================================================================
    // RXgN^
    //========================================================================
    public Plate(
        Color  col,    // \F
        int    style,  // \X^C
        double sh[][]  // `
    ) {
        this(col, col, style, sh);
    }

    public Plate(
        Color  lnCol,  // LINE\F
        Color  flCol,  // FILL\F
        int    style,  // \X^C
        double sh[][]  // `
    ) {
        this.lineCol = lnCol;
        this.fillCol = flCol;
        this.style = style;
        this.ptNum = sh.length;
        this.shape = sh;

        dispX = new int[ptNum];
        dispY = new int[ptNum];

        if(style == FL3D) {

            // Ae\Fe[u
            dispColTbl = new Color[19];
            for(int i=0; i<19; i++) {
                dispColTbl[i] = gainCol2(flCol, (9-i)*9);
            }

            // eӂɑ΂@xNg̐ݒ
            dispVect = new int[ptNum-1];
            vect = new int[ptNum-1];

            for(int i=0; i<ptNum-1; i++) {
                int vc1;
                int vc2;
                int lineDir;

                double cntX,  cntY;
                double chkX1, chkY1;
                double chkRng = 0.1;

                // ӂ̃xNg̎Zo
                lineDir = MyMath.getBrg(sh[i][0], sh[i][1],
                                        sh[i+1][0], sh[i+1][1]);

                // ӂƐȂQxNg̎Zo
                vc1 = lineDir - 90;
                vc2 = lineDir + 90;

                // ӂ̒ԓ_̎Zo
                cntX = (sh[i][0] + sh[i+1][0]) * 0.5;
                cntY = (sh[i][1] + sh[i+1][1]) * 0.5;

                // O`FbNpW̎Zo
                chkX1 = cntX + MyMath.cos(vc1) * chkRng;
                chkY1 = cntY + MyMath.sin(vc1) * chkRng;

                // O
                if(isInside(sh, chkX1, chkY1)) {
                    vect[i] = vc2;
                } else {
                    vect[i] = vc1;
                }
            }
        }
    }

    private final boolean isInside(
        double s[][],
        double ptx,
        double pty
    ) {
        int pts = s.length;
        double ptx2 = 10000.0;
        double pty2 = pty+1.0;

        int i = 0;
        int j = 0;
        int count = 0;

        for(i=0; i < pts-1; i++) {
//            if(!MyMath.isIntersect(s[i][0], s[i][1], s[i][0], s[i][1],
//                                   ptx, pty, ptx2, pty2)) {
//                if(MyMath.isIntersect(s[i][0], s[i][1], s[j][0], s[j][1],
//                                      ptx, pty, ptx2, pty2)) {
//                    count++;
//                }
//                j = i;
//            }

            if(MyMath.isIntersect(s[i][0], s[i][1], s[i+1][0], s[i+1][1],
                                  ptx, pty, ptx2, pty2)) {
                    count++;
            }
        }

        if((count & 1) == 1) {
            return true;
        } else {
            return false;
        }
    }

    //========================================================================
    // Method
    //========================================================================
    // \Fw`揈
    public final void draw(
        Graphics g,     // \ΏGraphics
        Color    lnCol, // LINE\F
        Color    flCol, // FILL\F
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[
        double scY      // \XP[
    ) {
        double tmpSin = MyMath.sin(vec); // sinl
        double tmpCos = MyMath.cos(vec); // cosl

        // `WvZ
        for(int i=0; i<ptNum; i++) {
            dispX[i] = (int)(x + (shape[i][0]*tmpCos*scX -
                                  shape[i][1]*tmpSin*scY));
            dispY[i] = (int)(y + (shape[i][0]*tmpSin*scX +
                                  shape[i][1]*tmpCos*scY));
        }

        // `p@xNgvZ
        if(style == FL3D) {
            for(int i=0; i<ptNum-1; i++) {
                dispVect[i] = MyMath.regDeg(vect[i] + vec);
            }
        }

        // `揈
        switch (style) {
            case LINE:
                // `X^C:
                // drawPolyline̋Javão[WɂĈႤ
                // 1.1 : I_`悵Ȃ
                // 1.3 : I_`悷
                // ̂ŁALINEX^ĈƂdrawLinegpĕ`
                g.setColor(lnCol);
//                g.drawPolyline(dispX, dispY, ptNum);
                for(int i=1; i<ptNum; i++) {
                    g.drawLine(dispX[i-1], dispY[i-1], dispX[i], dispY[i]);
                }
                break;

            case FILL:
                // `X^C:hԂ
                g.setColor(flCol);
                g.fillPolygon(dispX, dispY, ptNum);
                break;

            case LNFL:
                // `X^C:{hԂ
                g.setColor(flCol);
                g.fillPolygon(dispX, dispY, ptNum);

                g.setColor(lnCol);
                g.drawPolyline(dispX, dispY, ptNum);
                break;

            case FL3D:
                // `X^C:hԂ{Ae
                g.setColor(flCol);
                g.fillPolygon(dispX, dispY, ptNum);

                // PxZo
                int dVect;
                double gain;
                int gain2;

//                g.drawPolyline(dispX, dispY, ptNum);
                for(int i=0; i<ptNum-1; i++) {
//                    dVect = Math.abs(dispVect[i] - 225);
                    if(dispVect[i] < 45) {
                        dispVect[i] += 360;
                    }
                    dVect = Math.abs(dispVect[i] - 225);

//                    gain2 = (int)((90 - dVect) * 0.9);
//                    g.setColor(gainCol2(flCol, gain2));

                    g.setColor(dispColTbl[dVect / 10]);

                    g.drawLine(dispX[i], dispY[i], dispX[i+1], dispY[i+1]);
                }

//                g.setColor(Color.white);
//                for(int i=0; i<ptNum-1; i++) {
//                    int cntx, cnty;
//                    cntx = (dispX[i] + dispX[i+1]) / 2;
//                    cnty = (dispY[i] + dispY[i+1]) / 2;
//
//                    int tmpx, tmpy;
//                    tmpx = cntx + (int)(MyMath.cos(dispVect[i])*4.0);
//                    tmpy = cnty + (int)(MyMath.sin(dispVect[i])*4.0);
//
//                    g.drawLine(cntx, cnty, tmpx, tmpy);
//                }

                break;

            default:
                break;
        }
    }

    // PF\Fw`
    public final void draw(
        Graphics g,     // \ΏGraphics
        Color col,      // \F
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[X
        double scY      // \XP[Y
    ) {
//        draw(g, col, rdcCol(col), x, y, vec, scX, scY);
        draw(g, col, col, x, y, vec, scX, scY);
    }

    // Fw`
    public final void draw(
        Graphics g,     // \ΏGraphics
        double x,       // \W
        double y,       // \W
        int vec,        // \
        double scX,     // \XP[X
        double scY      // \XP[Y
    ) {
        draw(g, this.lineCol, this.fillCol, x, y, vec, scX, scY);
    }

    // Fϊ(Px)
    private final Color gainCol(
        Color col,      // F
        double gain     // Px
    ) {
        Color res;
        int colR;
        int colG;
        int colB;

        colR = col.getRed();
        colG = col.getGreen();
        colB = col.getBlue();

        colR = (int)(colR * gain);
        if(colR > 255) { colR = 255; }
        colG = (int)(colG * gain);
        if(colG > 255) { colG = 255; }
        colB = (int)(colB * gain);
        if(colB > 255) { colB = 255; }

        res = new Color((colR << 16) + (colG << 8) + colB);

        return res;
    }

    // Fϊ(Px)
    private final Color gainCol2(
        Color col,      // F
        int gain        // Px
    ) {
        Color res;
        int colR;
        int colG;
        int colB;

        colR = col.getRed();
        colG = col.getGreen();
        colB = col.getBlue();

        colR += gain;
        if(colR > 255) { colR = 255; }
        if(colR < 0) { colR = 0; }
        colG += gain;
        if(colG > 255) { colG = 255; }
        if(colG < 0) { colG = 0; }
        colB += gain;
        if(colB > 255) { colB = 255; }
        if(colB < 0) { colB = 0; }

        res = new Color((colR << 16) + (colG << 8) + colB);

        return res;
    }

    // Fϊ(PxƂ)
    private final Color rdcCol(
        Color col       // F
    ) {
        Color res;
        int colR;
        int colG;
        int colB;

        colR = col.getRed();
        colG = col.getGreen();
        colB = col.getBlue();

        colR = colR / 2;
        colG = colG / 2;
        colB = colB / 2;

        res = new Color((colR << 16) + (colG << 8) + colB);

        return res;
    }
}
