import java.awt.*;

public class Wall extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.WALL;

    private static final int life = 400;                    // 
    private static final int hp = 2;                        // ϋvx
    private static final double size = 9.0;                // TCY

    private static final int power = 16;                    // З
    private static final int points = 32;

    private static Plate plate[];                           // \Platez
    private static final int pNum = 1;                      // \Plate

    private static final Color colLn = new Color(0xffffff); // \F
    private static final Color colFl = new Color(0x909090); // \F
    private static final int style = Plate.FL3D;            // \X^C
    private static final double shape[][] = {               // `
        {  -9.0,  -7.0},
        {  -7.0,  -9.0},
        {   7.0,  -9.0},
        {   9.0,  -7.0},
        {   9.0,   7.0},
        {   7.0,   9.0},
        {  -7.0,   9.0},
        {  -9.0,   7.0},
        {  -9.0,  -7.0},
    };
    private static final Color colLn2 = new Color(0x808080); // \F
    private static final Color colFl2 = new Color(0xa0a0a0); // \F
    private static final int style2 = Plate.FL3D;           // \X^C
    private static final double shape2[][] = {              // `
        {  -5.0,  -5.0},
        {   5.0,  -5.0},
        {   5.0,   5.0},
        {  -5.0,   5.0},
        {  -5.0,  -5.0},
    };

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        plate = new Plate[pNum];
        plate[0] = new Plate(colLn, colFl, style, shape);
//        plate[1] = new Plate(colLn2, colFl2, style2, shape2);
    }

    //========================================================================
    // RXgN^
    //========================================================================
    Wall() {
        super(0.0, 0.0, size);
        super.setLife(life);
        super.setHp(hp);
    }
    Wall(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);
    }
    Wall(
        double posX,
        double posY,
        int th
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);
    }

    //========================================================================
    // Method
    //========================================================================
    // ʕ\
    public final void draw(
        Graphics g        // \ΏGraphics
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    // \Fwʕ\
    public final void draw(
        Graphics g,      // \ΏGraphics
        Color    col     // \F
    ) {
        for(int i=0; i<plate.length; i++) {
            plate[i].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
        }
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setScore(int sc) {
    }

    public final int getScore() {
        return 0;
    }

    public final int getScoreCntr() {
        return 0;
    }

    public final void incScoreCntr() {
    }

    public final void setScoreCntr(int cnt) {
    }

    public final void setTurret(
        int th
    ) {
    }

    public final void setDir(int d) {
    }

    public final int getDir() {
        return 0;
    }
}
