import java.awt.*;

public final class EnemyD extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_D;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 12;                         // ϋvx
    private static final double size = 9.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 240;

    static Picture pict;
    static int pictId;
    static Render render;

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;
    private int turretTh;
    private int dir;

    //========================================================================
    // ÓI
    //========================================================================
    static {
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyD() {
        super(0.0, 0.0, size);

        cntr = 0;
        turretTh = 90;
    }
    EnemyD(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
        turretTh = 90;
    }
    EnemyD(
        int id,
        double posX,
        double posY,
        int th,
        Render rend, Picture picture, int picId
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        render = rend;
        pict = picture;
        pictId = picId;

        eid = id;
        cntr = 0;
        turretTh = 90;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    public final void setTurret(
        int th
    ) {
        turretTh = th;
    }

    // ʕ\
    public final void draw(
    ) {
        render.drawRotImage(pict, pictId, (int)getPosX(), (int)getPosY(), getVecTh(), Render.DRAW_FULL);
        render.drawRotImage(pict, pictId+1, (int)getPosX(), (int)getPosY(), turretTh, Render.DRAW_FULL);
    }

    // \Fwʕ\
    public final void draw(
        int      col     // \F
    ) {
        render.drawRotImage(pict, pictId, (int)getPosX(), (int)getPosY(), getVecTh(), Render.DRAW_FULL, col);
        render.drawRotImage(pict, pictId+1, (int)getPosX(), (int)getPosY(), turretTh, Render.DRAW_FULL, col);
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setDir(int d) {
        dir = d;
    }

    public final int getDir() {
        return dir;
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
        turretTh = 90;
    }
}
