import java.awt.*;
import java.awt.image.*;
//import java.io.PrintStream;

public final class Render implements ImageProducer {
    static final int scrnWidth = 340;
    static final int scrnHeight = 364;

    static final int DRAW_ADD  = 20;
    static final int DRAW_FULL = 16;
    static final int DRAW_HALF = 8;
    static final int DRAW_50   = 8;
    static final int DRAW_75   = 12;
    static final int DRAW_25   = 4;

    static final int scrnPixelNum = scrnWidth * scrnHeight;
    private final int scrnBuff[] = new int[scrnPixelNum];
    private final int lineBuff[] = new int[scrnWidth];

//    private final int scrnBuff2[] = new int[scrnPixelNum*4];

    private ColorModel colorModel;
    private Image scrnImage;
    private ImageConsumer imageConsumer;
    private Graphics scrGraphics;

    private boolean isStart;

    final void updateScreen() {
        if(!isStart) {
            return;
        }

//        for(int y=0; y<scrnHeight; y++) {
//            for(int x=0; x<scrnWidth; x++) {
//                scrnBuff2[y*scrnWidth*4+x*2] = scrnBuff[y*scrnWidth+x];
//                scrnBuff2[y*scrnWidth*4+x*2+1] = scrnBuff[y*scrnWidth+x];
//            }
//        }

        imageConsumer.setPixels(0, 0, scrnWidth, scrnHeight, colorModel, scrnBuff, 0, scrnWidth);
//        imageConsumer.setPixels(0, 0, scrnWidth*2, scrnHeight*2, colorModel, scrnBuff2, 0, scrnWidth*2);

        scrGraphics.drawImage(scrnImage, 0, 0, null);
//        scrGraphics.drawImage(scrnImage, 0, 0, scrnWidth*2, scrnHeight*2, null);

        imageConsumer.imageComplete(2);
        return;
    }

    // ʃobt@
    final void init() {
        for(int i = 0; i < scrnPixelNum; i++) {
            scrnBuff[i] = 0;
        }
    }

    // ʃobt@NA
    final void clear(int color) {
        for(int i = 0; i < scrnPixelNum; i++) {
            scrnBuff[i] = color;
        }
    }

    final void fadeOut() {
        int r;
        int g;
        int b;
        for(int i = 0; i < scrnPixelNum; i++) {
            r = scrnBuff[i] & 0xfe0000;
            g = scrnBuff[i] & 0xfe00;
            b = scrnBuff[i] & 0xfe;
            if(r != 0 ) {
                r = r - 0x20000;
            }
            if(g != 0 ) {
                g = g - 0x200;
            }
            if(b != 0 ) {
                b = b - 0x2;
            }
//            r = scrnBuff[i] & 0xff0000;
//            g = scrnBuff[i] & 0xff00;
//            b = scrnBuff[i] & 0xff;
//            if(r != 0 ) {
//                r = r - 0x10000;
//            }
//            if(g != 0 ) {
//                g = g - 0x100;
//            }
//            if(b != 0 ) {
//                b = b - 0x1;
//            }
            scrnBuff[i] = r | g | b;
        }
    }

    // RXgN^
    public Render(Graphics g) {
        isStart = false;
        scrGraphics = g;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        scrnImage = toolkit.createImage(this);
        toolkit.prepareImage(scrnImage, scrnWidth, scrnHeight, null);
//        toolkit.prepareImage(scrnImage, scrnWidth*2, scrnHeight*2, null);
    }

    // ]摜`揈
    final void drawRotImage(
        Picture picture,
        int chr,
        int x,
        int y,
        int r
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(), DRAW_FULL, 0);
    }

    // ]摜`揈
    final void drawRotImage(
        Picture picture,
        int chr,
        int x,
        int y,
        int r,
        int alpha
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(), alpha, 0);
    }

    // ]摜`揈
    final void drawRotImage(
        Picture picture,
        int chr,
        int x,
        int y,
        int r,
        int alpha,
        int color
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(), alpha, color);
    }

    // 摜`揈
    final void drawImage(
        Picture picture,
        int chr,
        int x,
        int y
    ) {
        drawImageAlpha(picture.getPixel(chr), x, y,
                       picture.getWidth(), picture.getHeight(), DRAW_FULL, 0);
    }

    // 摜`揈
    final void drawImage(
        Picture picture,
        int chr,
        int x,
        int y,
        int alpha
    ) {
        drawImageAlpha(picture.getPixel(chr), x, y, picture.getWidth(),
                       picture.getHeight(), alpha, 0);
    }

    // gk`揈
    final void drawScaledImage(
        Picture picture,
        int chr,
        int posX,
        int posY,
        double scale
    ) {
        drawScaledImageAlpha(picture.getPixel(chr), posX, posY,
                       picture.getWidth(), picture.getHeight(), scale, DRAW_FULL);
    }

    // gk`揈
    final void drawScaledImage(
        Picture picture,
        int chr,
        int posX,
        int posY,
        double scale,
        int alpha
    ) {
        drawScaledImageAlpha(picture.getPixel(chr), posX, posY,
                       picture.getWidth(), picture.getHeight(), scale, alpha);
    }

    // ]gk摜`揈
    final void drawRotScaledImage(
        Picture picture,
        int chr,
        int posX,
        int posY,
        int r,
        double scale,
        int alpha
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }

        drawScaledImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC), posX, posY,
                       picture.getRotWidth(), picture.getRotHeight(), scale, alpha);
    }

    // \SWw 摜`揈
    final void drawImageCenter(
        Picture picture,
        int chr,
        int x,
        int y
    ) {
        drawImageAlpha(picture.getPixel(chr),
                       x - picture.getWidth()/2,
                       y - picture.getHeight()/2,
                       picture.getWidth(), picture.getHeight(), DRAW_FULL, 0);
    }

    // \SWw 摜`揈
    final void drawImageCenter(
        Picture picture,
        int chr,
        int x,
        int y,
        int alpha
    ) {
        drawImageAlpha(picture.getPixel(chr),
                       x - picture.getWidth()/2,
                       y - picture.getHeight()/2,
                       picture.getWidth(), picture.getHeight(), alpha, 0);
    }

    // 4bit AlphaBlending摜`
    private final void drawImageAlpha(
        int pixelBuff[],    // `pixel
        int posX,           // `W
        int posY,           // `W
        int width,          // `敝
        int height,         // `捂
        int alpha,          // alphal(1..16)
        int color
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_ADD)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(alpha == DRAW_FULL) {
            // 100%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            scrnBuff[dstPtr+x] = pixelBuff[srcPtr+x];
                        } else {
                            scrnBuff[dstPtr+x] = color;
                        }
                    }
                }
            }
        } else if(alpha == DRAW_HALF) {
            // 50%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            scrnBuff[dstPtr+x] =
                                ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                                (pixelBuff[srcPtr+x] >> 1);
                        } else {
                            scrnBuff[dstPtr+x] =
                                ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                                (color >> 1);
                        }
                    }
                }
            }
        } else if(alpha == DRAW_ADD) {
            // PZ`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            int r;
                            int g;
                            int b;
                            r = (scrnBuff[dstPtr+x] & 0xff0000) + (pixelBuff[srcPtr+x] & 0xff0000);
                            g = (scrnBuff[dstPtr+x] & 0xff00) + (pixelBuff[srcPtr+x] & 0xff00);
                            b = (scrnBuff[dstPtr+x] & 0xff) + (pixelBuff[srcPtr+x] & 0xff);

                            if(r > 0xff0000) r = 0xff0000;
                            if(g > 0xff00) g = 0xff00;
                            if(b > 0xff) b = 0xff;

                            scrnBuff[dstPtr+x] = r | g | b;
                        } else {
                            scrnBuff[dstPtr+x] =
                                ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                                (color >> 1);
                        }
                    }
                }
            }
        } else if(alpha == DRAW_75) {
            // 75%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            scrnBuff[dstPtr+x] =
                                ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                                pixelBuff[srcPtr+x] -
                                (pixelBuff[srcPtr+x] >> 2);
                        } else {
                            scrnBuff[dstPtr+x] =
                                ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                                color -
                                (color >> 2);
                        }
                    }
                }
            }
        } else if(alpha == DRAW_25) {
            // 25%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            scrnBuff[dstPtr+x] =
                                scrnBuff[dstPtr+x] -
                                ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                                (pixelBuff[srcPtr+x] >> 2);
                        } else {
                            scrnBuff[dstPtr+x] =
                                scrnBuff[dstPtr+x] -
                                ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                                (color >> 2);
                        }
                    }
                }
            }
        } else {
            // ȊO̕`
            int alphaN = DRAW_FULL - alpha;
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            int col = ((scrnBuff[dstPtr+x] & 0xff00ff) * alphaN +
                                       (pixelBuff[srcPtr+x] & 0xff00ff) * alpha) &
                                      0x0ff00ff0;
                            col |= ((scrnBuff[dstPtr+x] & 0xff00) * alphaN +
                                    (pixelBuff[srcPtr+x] & 0xff00) * alpha) &
                                   0x000ff000;
                            scrnBuff[dstPtr+x] = col >> 4;
                        } else {
                            int col = ((scrnBuff[dstPtr+x] & 0xff00ff) * alphaN +
                                       (color & 0xff00ff) * alpha) &
                                      0x0ff00ff0;
                            col |= ((scrnBuff[dstPtr+x] & 0xff00) * alphaN +
                                    (color & 0xff00) * alpha) &
                                   0x000ff000;
                            scrnBuff[dstPtr+x] = col >> 4;
                        }
                    }
                }
            }
        }
    }

    // 4bit AlphaBlending摜gk`
    private final void drawScaledImageAlpha(
        int pixelBuff[],
        int cntX,           // `撆SW
        int cntY,           // `撆SW
        int width,
        int height,
        double scale,
        int alpha           // alphal(1..16)
    ) {
        int scWidth  = (int)(width * scale + 0.5);
        int scHeight = (int)(height * scale + 0.5);

        int posX = cntX - scWidth/2;
        int posY = cntY - scHeight/2;

        if((posX+scWidth < 0) || (posY+scHeight < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = scWidth;
        y1 = 0;
        y2 = scHeight;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+scWidth) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+scHeight) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(alpha == DRAW_FULL) {
            // 100%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        scrnBuff[dstPtr+x] = pixelBuff[srcPtr+tmpX];
                    }
                }
            }
        } else if(alpha == DRAW_HALF) {
            // 50%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        scrnBuff[dstPtr+x] =
                            ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                            (pixelBuff[srcPtr+tmpX] >> 1);
                    }
                }
            }
        } else if(alpha == DRAW_75) {
            // 75%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        scrnBuff[dstPtr+x] =
                            ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                            pixelBuff[srcPtr+tmpX] -
                            (pixelBuff[srcPtr+tmpX] >> 2);
                    }
                }
            }
        } else if(alpha == DRAW_25) {
            // 25%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        scrnBuff[dstPtr+x] =
                            scrnBuff[dstPtr+x] -
                            ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                            (pixelBuff[srcPtr+tmpX] >> 2);
                    }
                }
            }
        } else {
            // ȊO̕`
            int alphaN = DRAW_FULL - alpha;
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        int col = ((scrnBuff[dstPtr+x] & 0xff00ff) * alphaN +
                                   (pixelBuff[srcPtr+tmpX] & 0xff00ff) * alpha) &
                                  0x0ff00ff0;
                        col |= ((scrnBuff[dstPtr+x] & 0xff00) * alphaN +
                                (pixelBuff[srcPtr+tmpX] & 0xff00) * alpha) &
                               0x000ff000;
                        scrnBuff[dstPtr+x] = col >> 4;
                    }
                }
            }
        }
    }

    // ``揈
    final void fillRect(
        int x,
        int y,
        int w,
        int h,
        int col
    ) {
        fillRectAlpha(x, y, w, h, col, DRAW_FULL);
    }

    // ``揈
    final void fillRect(
        int x,
        int y,
        int w,
        int h,
        int col,
        int alpha
    ) {
        fillRectAlpha(x, y, w, h, col, alpha);
    }

    // 4bit AlphaBlending``
    private final void fillRectAlpha(
        int posX,           // `W
        int posY,           // `W
        int width,          // `敝
        int height,         // `捂
        int color,          // `F
        int alpha           // alphal(1..16)
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(alpha == DRAW_FULL) {
            // 100%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    scrnBuff[dstPtr+x] = color;
                }
            }
        } else if(alpha == DRAW_HALF) {
            // 50%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    scrnBuff[dstPtr+x] =
                        ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                         (color >> 1);
                }
            }
        } else if(alpha == DRAW_75) {
            // 75%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    scrnBuff[dstPtr+x] =
                        ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                        color -
                        (color >> 2);
                }
            }
        } else if(alpha == DRAW_25) {
            // 25%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    scrnBuff[dstPtr+x] =
                        scrnBuff[dstPtr+x] -
                        ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                        (color >> 2);
                }
            }
        } else {
            // ȊO̕`
            int alphaN = DRAW_FULL - alpha;
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    int col = ((scrnBuff[dstPtr+x] & 0xff00ff) * alphaN +
                              (color & 0xff00ff) * alpha) &
                              0x0ff00ff0;
                    col |= ((scrnBuff[dstPtr+x] & 0xff00) * alphaN +
                            (color & 0xff00) * alpha) &
                            0x000ff000;
                    scrnBuff[dstPtr+x] = col >> 4;
                }
            }
        }
    }

    // ``揈
    final void drawRect(
        int x,
        int y,
        int w,
        int h,
        int col
    ) {
        drawRectAlpha(x, y, w, h, col, DRAW_FULL);
    }

    // ``揈
    final void drawRect(
        int x,
        int y,
        int w,
        int h,
        int col,
        int alpha
    ) {
        drawRectAlpha(x, y, w, h, col, alpha);
    }

    // 4bit AlphaBlending``
    private final void drawRectAlpha(
        int posX,           // `W
        int posY,           // `W
        int width,          // `敝
        int height,         // `捂
        int color,          // `F
        int alpha           // alphal(1..16)
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(alpha == DRAW_FULL) {
            // 100%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                if((y == y1) || (y == y2-1)) {
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[dstPtr+x] = color;
                    }
                } else {
                    scrnBuff[dstPtr+x1] = color;
                    scrnBuff[dstPtr+x2-1] = color;
                }
            }
        } else if(alpha == DRAW_HALF) {
            // 50%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                if((y == y1) || (y == y2-1)) {
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[dstPtr+x] =
                            ((scrnBuff[dstPtr+x] & 0xfefefe) >> 1) +
                             (color >> 1);
                    }
                } else {
                    scrnBuff[dstPtr+x1] =
                        ((scrnBuff[dstPtr+x1] & 0xfefefe) >> 1) +
                         (color >> 1);
                    scrnBuff[dstPtr+x2-1] =
                        ((scrnBuff[dstPtr+x2-1] & 0xfefefe) >> 1) +
                         (color >> 1);
                }
            }
        } else if(alpha == DRAW_75) {
            // 75%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                if((y == y1) || (y == y2-1)) {
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[dstPtr+x] =
                            ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                            color -
                            (color >> 2);
                    }
                } else {
                    scrnBuff[dstPtr+x1] =
                        ((scrnBuff[dstPtr+x1] & 0xfcfcfc) >> 2) +
                        color -
                        (color >> 2);
                    scrnBuff[dstPtr+x2-1] =
                        ((scrnBuff[dstPtr+x2-1] & 0xfcfcfc) >> 2) +
                        color -
                        (color >> 2);
                }
            }
        } else if(alpha == DRAW_25) {
            // 25%`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                if((y == y1) || (y == y2-1)) {
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[dstPtr+x] =
                            scrnBuff[dstPtr+x] -
                            ((scrnBuff[dstPtr+x] & 0xfcfcfc) >> 2) +
                            (color >> 2);
                    }
                } else {
                    scrnBuff[dstPtr+x1] =
                        scrnBuff[dstPtr+x1] -
                        ((scrnBuff[dstPtr+x1] & 0xfcfcfc) >> 2) +
                        (color >> 2);
                    scrnBuff[dstPtr+x2-1] =
                        scrnBuff[dstPtr+x2-1] -
                        ((scrnBuff[dstPtr+x2-1] & 0xfcfcfc) >> 2) +
                        (color >> 2);
                }
            }
        } else {
            // ȊO̕`
            int alphaN = DRAW_FULL - alpha;
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                if((y == y1) || (y == y2-1)) {
                    for(int x=x1; x < x2; x++) {
                        int col = ((scrnBuff[dstPtr+x] & 0xff00ff) * alphaN +
                                  (color & 0xff00ff) * alpha) &
                                  0x0ff00ff0;
                        col |= ((scrnBuff[dstPtr+x] & 0xff00) * alphaN +
                                (color & 0xff00) * alpha) &
                                0x000ff000;
                        scrnBuff[dstPtr+x] = col >> 4;
                    }
                } else {
                    int col = ((scrnBuff[dstPtr+x1] & 0xff00ff) * alphaN +
                              (color & 0xff00ff) * alpha) &
                              0x0ff00ff0;
                    col |= ((scrnBuff[dstPtr+x1] & 0xff00) * alphaN +
                            (color & 0xff00) * alpha) &
                            0x000ff000;
                    scrnBuff[dstPtr+x1] = col >> 4;
                    col = ((scrnBuff[dstPtr+x2-1] & 0xff00ff) * alphaN +
                              (color & 0xff00ff) * alpha) &
                              0x0ff00ff0;
                    col |= ((scrnBuff[dstPtr+x2-1] & 0xff00) * alphaN +
                            (color & 0xff00) * alpha) &
                            0x000ff000;
                    scrnBuff[dstPtr+x2-1] = col >> 4;
                }
            }
        }
    }

    final void drawPixels(
        int posX[],
        int posY[],
        int color[],
        int pNum
    ) {
        for(int i = 0; i<pNum; i++) {
            scrnBuff[posY[i] * scrnWidth + posX[i]] = color[i];
        }
    }

    // X^XN[
    final void rasterScroll(
        int vLine,  // XN[C
        int hPos    // `Jnʒu
    ) {
        int pos;
        if(hPos < 0) {
            pos = scrnWidth+hPos;
        } else {
            pos = hPos;
        }

        if(pos < 0 || pos >= scrnWidth) {
            return;
        }

        int scrnPtr = vLine * scrnWidth;
        int i;
        for(i=0; i<pos; i++) {
            lineBuff[i] = scrnBuff[scrnPtr+i];
        }
        for(i=0; i<scrnWidth - pos; i++) {
            scrnBuff[scrnPtr+i] = scrnBuff[scrnPtr+pos+i];
        }
        for(i=0; i<pos; i++) {
            scrnBuff[scrnPtr+scrnWidth-pos+i] = lineBuff[i];
        }
    }

    // `揈
    final void drawString(
        Picture picture,
        int x,
        int y,
        String str,
        int alpha,
        int col
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w, y, w, h, alpha, col);
        }
    }

    // `揈
    final void drawString(
        Picture picture,
        int x,
        int y,
        String str,
        int alpha
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w, y, w, h, alpha, 0);
        }
    }

    // `揈
    final void drawScaledString(
        Picture picture,
        int x,
        int y,
        String str,
        double scale,
        int alpha
    ) {
        int ch;
        int w = picture.getWidth();
        double strWidth = (int)(str.length() * w * scale);
        int strHeight = (int)(picture.getHeight() * scale);
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawScaledImage(picture, ch, (int)(x-strWidth/2+(i+0.5)*w*scale), y-strHeight/2, scale, alpha);
        }
    }

    // `揈
    final void drawStringCenter(
        Picture picture,
        int x,
        int y,
        String str,
        int alpha,
        int col
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        int strWidth = str.length() * w;
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x-strWidth/2+i*w, y-h/2, w, h, alpha, col);
        }
    }

    // `揈
    final void drawStringCenter(
        Picture picture,
        int x,
        int y,
        String str,
        int alpha
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        int strWidth = str.length() * w;
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w-strWidth/2, y-h/2, w, h, alpha, 0);
        }
    }

    // Line`揈
    final void drawLineX(
        int x1,
        int x2,
        int y,
        int color,
        int alpha
    ) {
        // `͈̓`FbN
        if(y < 0 || y >= scrnHeight) {
            return;
        }
        if(x1 > x2) {
            return;
        }

        if(x1 < 0) {
            x1 = 0;
        }
        if(x2 >= scrnWidth) {
            x2 = scrnWidth;
        }

        if(alpha == DRAW_FULL) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[y * scrnWidth + x] = color;
            }
        } else if(alpha == DRAW_HALF) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[y * scrnWidth + x] =
                            ((scrnBuff[y * scrnWidth + x] & 0xfefefe) >> 1) +
                             (color >> 1);
            }
        } else if(alpha == DRAW_75) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[y * scrnWidth + x] =
                            ((scrnBuff[y * scrnWidth + x] & 0xfcfcfc) >> 2) +
                            color -
                            (color >> 2);
            }
        } else if(alpha == DRAW_25) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[y * scrnWidth + x] =
                            scrnBuff[y * scrnWidth + x] -
                            ((scrnBuff[y * scrnWidth + x] & 0xfcfcfc) >> 2) +
                            (color >> 2);
            }
        } else {
            int alphaN = DRAW_FULL - alpha;
            for(int x=x1; x<x2; x++) {
                int col = ((scrnBuff[y * scrnWidth + x] & 0xff00ff) * alphaN +
                          (color & 0xff00ff) * alpha) &
                          0x0ff00ff0;
                col |= ((scrnBuff[y * scrnWidth + x] & 0xff00) * alphaN +
                        (color & 0xff00) * alpha) &
                        0x000ff000;
                scrnBuff[y * scrnWidth + x] = col >> 4;
            }
        }
    }

    // cLine`揈
    final void drawLineY(
        int x,
        int y1,
        int y2,
        int color,
        int alpha
    ) {
        // `͈̓`FbN
        if(x < 0 || x >= scrnWidth) {
            return;
        }
        if(y1 > y2) {
            return;
        }

        if(y1 < 0) {
            y1 = 0;
        }
        if(y2 >= scrnHeight) {
            y2 = scrnHeight;
        }

        if(alpha == DRAW_FULL) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[y * scrnWidth + x] = color;
            }
        } else if(alpha == DRAW_HALF) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[y * scrnWidth + x] =
                            ((scrnBuff[y * scrnWidth + x] & 0xfefefe) >> 1) +
                             (color >> 1);
            }
        } else if(alpha == DRAW_75) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[y * scrnWidth + x] =
                            ((scrnBuff[y * scrnWidth + x] & 0xfcfcfc) >> 2) +
                            color -
                            (color >> 2);
            }
        } else if(alpha == DRAW_25) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[y * scrnWidth + x] =
                            scrnBuff[y * scrnWidth + x] -
                            ((scrnBuff[y * scrnWidth + x] & 0xfcfcfc) >> 2) +
                            (color >> 2);
            }
        } else {
            int alphaN = DRAW_FULL - alpha;
            for(int y=y1; y<y2; y++) {
                int col = ((scrnBuff[y * scrnWidth + x] & 0xff00ff) * alphaN +
                          (color & 0xff00ff) * alpha) &
                          0x0ff00ff0;
                col |= ((scrnBuff[y * scrnWidth + x] & 0xff00) * alphaN +
                        (color & 0xff00) * alpha) &
                        0x000ff000;
                scrnBuff[y * scrnWidth + x] = col >> 4;
            }
        }
    }

    // 16bit Line`揈
    final void drawLine16(
        int x1,     // n_W
        int y1,     // n_W
        int x2,     // I_W
        int y2,     // I_W
        int color   // `F
    ) {
        int xChkFlag = 0;
        int yChkFlag = 0;

        // `̈攻
        if(x1 < 0)             xChkFlag |= 1;
        if(x1 >= scrnWidth)  xChkFlag |= 2;
        if(y1 < 0)             xChkFlag |= 4;
        if(y1 >= scrnHeight) xChkFlag |= 8;
        if(x2 < 0)             yChkFlag |= 1;
        if(x2 >= scrnWidth)  yChkFlag |= 2;
        if(y2 < 0)             yChkFlag |= 4;
        if(y2 >= scrnHeight) yChkFlag |= 8;

        if((xChkFlag & yChkFlag) != 0) {
            return;
        } else {
            drawline(x1 << 16, y1 << 16, x2 << 16, y2 << 16, color);
            return;
        }
    }

    private final void drawline(
        int x1,     // n_W(16bitVtg)
        int y1,     // n_W(16bitVtg)
        int x2,     // I_W(16bitVtg)
        int y2,     // I_W(16bitVtg)
        int color   // `F
    ) {
        int xDiff = Math.abs((x2 >> 16) - (x1 >> 16));
        int yDiff = Math.abs((y2 >> 16) - (y1 >> 16));

        if(xDiff < yDiff) {
            if(yDiff == 0) {
                yDiff++;
            }

            int xAdd = (x2 - x1) / yDiff;
            int yAdd = (y2 - y1) >> 31 | 1;
            y1 = y1 >> 16;

            for(int yLoop = 0; yLoop < yDiff; yLoop++) {
                int xTmp = x1 >> 16;

                if(xTmp >= 0 &&
                   xTmp < (scrnWidth - 1) &&
                   y1 >= 0 &&
                   y1 < (scrnHeight - 1)) {
                    int scrnPtr = y1 * scrnWidth + xTmp;
                    int xCalc = (x1 >> 8) & 0xff;
                    scrnBuff[scrnPtr] = calcPixelColor(scrnBuff[scrnPtr], color, xCalc);
                    scrnBuff[scrnPtr + 1] = calcPixelColor(scrnBuff[scrnPtr + 1], color, 0xff - xCalc);
                }

                x1 += xAdd;
                y1 += yAdd;
            }
        } else {
            if(xDiff == 0) {
                xDiff++;
            }

            int yAdd = (y2 - y1) / xDiff;
            int xAdd = (x2 - x1) >> 31 | 1;
            x1 = x1 >> 16;

            for(int xLoop = 0; xLoop < xDiff; xLoop++) {
                int yTmp = y1 >> 16;

                if(yTmp >= 0 &&
                   yTmp < (scrnHeight - 1) &&
                   x1 >= 0 &&
                   x1 < (scrnWidth - 1)) {
                    int scrnPtr = yTmp * scrnWidth + x1;
                    int yCalc = (y1 >> 8) & 0xff;
                    scrnBuff[scrnPtr] = calcPixelColor(scrnBuff[scrnPtr], color, yCalc);
                    scrnBuff[scrnPtr + scrnWidth] = calcPixelColor(scrnBuff[scrnPtr + scrnWidth], color, 0xff - yCalc);
                }

                x1 += xAdd;
                y1 += yAdd;
            }
        }
    }

    // 16bit Line`ppixelvZ
    private static final int calcPixelColor(
        int baseColor,
        int drawColor,
        int blend
    ) {
        int blendN = 0xff - blend;

        int newColor = (baseColor & 0xff0000) * blend + (drawColor & 0xff0000) * blendN & 0xff000000;
        newColor |= (baseColor & 0xff00) * blend + (drawColor & 0xff00) * blendN & 0xff0000;
        newColor |= (baseColor & 0xff) * blend + (drawColor & 0xff) * blendN;
        return newColor >> 8;
    }

    public final void startProduction(ImageConsumer imageconsumer) {
        colorModel = new DirectColorModel(24, 0xff0000, 0xff00, 0xff);
        imageConsumer = imageconsumer;
//        imageConsumer.setDimensions(scrnWidth*2, scrnHeight*2);
        imageConsumer.setDimensions(scrnWidth, scrnHeight);
        imageConsumer.setColorModel(colorModel);
        Render _tmp = this;
        imageConsumer.setHints(
            // 2:sNZ̓C[W̏ォ牺AȄőB
            ImageConsumer.TOPDOWNLEFTRIGHT |
            // 4:sNZ͍s(XLC)PʂőBs܂Ƃ߂
            //   邩ȂAs̓r܂ł𑗂邱Ƃ͂ȂB
            ImageConsumer.COMPLETESCANLINES |
            // 8:ꏊ̃sNZ2ȏ㑗邱Ƃ͂ȂB
            ImageConsumer.SINGLEPASS |
            // 16:C[W͂P̃t[łĂB
            ImageConsumer.SINGLEFRAME
        );
        isStart = true;
    }

    public final void addConsumer(ImageConsumer imageconsumer) {
        System.out.println("!addConsumer");
    }

    public final boolean isConsumer(ImageConsumer imageconsumer) {
        System.out.println("!isConsumer");
        return false;
    }

    public final void removeConsumer(ImageConsumer imageconsumer) {
        System.out.println("!removeConsumer");
    }

    public final void requestTopDownLeftRightResend(ImageConsumer imageconsumer) {
        System.out.println("!requestTopDownLeftRightResend");
    }

    public final void paint(Graphics g) {
        drawScreen();
    }

    public final void repaint() {
        drawScreen();
    }

    public final void update(Graphics g) {
        drawScreen();
    }

    private final void drawScreen() {
        updateScreen();
    }
}
