import java.awt.*;

public final class EnemyA extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.TYPE_A;

    private static final int num = 16;                        // 
    private static final int life = 400;                      // 
    private static final int hp = 2;                          // ϋvx
    private static final double size = 6.0;                   // TCY
    private static final int power = 16;                      // З
    private static final int points = 40;

    static Picture pict;
    static int pictId;
    static Render render;

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;
    private int score;
    private int scoreCntr;
    private int dir;

    //========================================================================
    // ÓI
    //========================================================================
    static {
    }

    //========================================================================
    // RXgN^
    //========================================================================
    EnemyA() {
        super(0.0, 0.0, size);

        cntr = 0;
    }
    EnemyA(
        double posX,
        double posY
    ) {
        super(posX, posY, size);
        super.setLife(life);
        super.setHp(hp);

        cntr = 0;
    }
    EnemyA(
        int id,
        double posX,
        double posY,
        int th,
        Render rend, Picture picture, int picId
    ) {
        super(posX, posY, th, size);
        super.setLife(life);
        super.setHp(hp);

        render = rend;
        pict = picture;
        pictId = picId;

        eid = id;
        cntr = 0;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    // ʕ\
    public final void draw(
    ) {
        render.drawRotImage(pict, pictId, (int)getPosX()+4, (int)getPosY()+4, getVecTh(), Render.DRAW_50, 0x404040);
        render.drawRotImage(pict, pictId, (int)getPosX(), (int)getPosY(), getVecTh(), Render.DRAW_FULL);
//        for(int i=0; i<plate.length; i++) {
//            plate[i].draw(g, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
//        }
    }

    // \Fwʕ\
    public final void draw(
        int      col     // \F
    ) {
        render.drawRotImage(pict, pictId, (int)getPosX(), (int)getPosY(), getVecTh(), Render.DRAW_FULL, col);
//        for(int i=0; i<plate.length; i++) {
//            plate[i].draw(g, col, getPosX(), getPosY(), getVecTh(), getScale(), getScale());
//        }
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    public final void setScore(int sc) {
        score = sc;
    }

    public final int getScore() {
        return score;
    }

    public final int getScoreCntr() {
        return scoreCntr;
    }

    public final void incScoreCntr() {
        scoreCntr++;
    }

    public final void setScoreCntr(int cnt) {
        scoreCntr = cnt;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    public final void setTurret(
        int th
    ) {
    }

    public final void setDir(int d) {
        dir = d;
    }

    public final int getDir() {
        return dir;
    }

    // 
    public final void init(double posx, double posy, int flag) {
        setPos(posx, posy);
        setVecTh(90);
        setVelTh(0);
        setVec(90, 3.0);
        setDir(90);
        setLife(life);
        setHp(hp);
        setDamage(0);
        setScale(1.0);
        cntr = 0;
        score = 0;
        scoreCntr = 0;
    }
}
