import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
//import java.io.PrintStream;

final class Picture {
    static boolean err;

    private static int loadedNum;

    // QƂApplet
    private static Applet baseApplet;

    // fBAgbJ[
    private static MediaTracker mt;

    // 摜t@C̐IuWFNg
    private static Picture pictureObject[];

    // pictureObject̃TCY
    static final int MAX = 16;

    // 摜t@C̐̃JE^
    private static int pictureCounter;

    // Picture(摜t@C)
    private String pictureName;

    // P̌摜t@Cɑ΂ĕ̃obt@
    private int pixelArray[][];

    private int pixelRotArray[][][];
    private int rotWidth;
    private int rotHeight;
    static final int ROT_NUM = 72;
    static final int DEGREE = 360;
    static final int ROT_PREC = DEGREE / ROT_NUM;

    // 摜t@ĈPIuWFNg̕
    private int cellWidth;

    // 摜t@ĈPIuWFNg̍
    private int cellHeight;

    // ̎擾
    final String getName() {
        return pictureName;
    }

    // 摜t@CP̍\擾
    final int getNum() {
        return pixelArray.length;
    }

    // pixel擾
    final int[] getPixel(int idx) {
        return pixelArray[idx];
    }

    // image̕擾
    final int getWidth() {
        return cellWidth;
    }

    // image̍擾
    final int getHeight() {
        return cellHeight;
    }

    // pixel擾
    final int[] getRotPixel(int idx, int r) {
        return pixelRotArray[idx][r];
    }

    // image̕擾
    final int getRotWidth() {
        return rotWidth;
    }

    // image̍擾
    final int getRotHeight() {
        return rotHeight;
    }

    // Picturestaticȏ
    static void init(Applet applet) {
        System.out.println("Picture.init");

        baseApplet = applet;
        mt = new MediaTracker(applet);

        pictureObject = new Picture[MAX];
        pictureCounter = 0;
        loadedNum = 1;
        err = false;
    }

    // Pictureobject̉
    static void release() {
        System.out.println("Picture.release");
        pictureObject = null;
        System.gc();
    }

    // Pictureobject
    static int create(
        String fileName,
        int xSize,
        int ySize,
        int xNum,
        int yNum
    ) {
        try {
            // ǃt@Cǂ̔
            for(int chk = 0; chk < MAX &&
                             pictureObject[chk] != null &&
                             pictureObject[chk].pictureName != null; chk++) {
                if(pictureObject[chk].pictureName.equals(fileName)) {
                    return chk;
                }
            }

            System.out.println(fileName);

            // 摜t@Cǂݍ
            Image image = baseApplet.getImage(baseApplet.getCodeBase(), fileName);

            // fBAgbJ[ɓo^
            mt.addImage(image, 0);

            // ǂݍ݊҂
            mt.waitForID(0);

            // f荞
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if(width <= 0 || height <= 0) {
                throw new Exception("Cannot read "+fileName);
            } else {
                int pixelBuff[] = new int[width * height];

                PixelGrabber pixelgrabber = new PixelGrabber(image,
                                                             0,
                                                             0,
                                                             width,
                                                             height,
                                                             pixelBuff,
                                                             0,
                                                             width);
                pixelgrabber.grabPixels();
                pixelgrabber = null;

                // Imagẻ
                image.flush();
                // Kx[WRNV{
                System.gc();

                // VPictureIuWFNg̐
                Picture picture = new Picture(fileName);

                // pixelBuff̓ePictureIuWFNgɐݒ
                picture.setPictureSource(pixelBuff, width, height, xSize, ySize, xNum, yNum);
                int id = pictureCounter;
                pictureObject[id] = picture;
                pictureCounter++;

                // PictureidԂ
                return id;
            }
        } catch(Exception exception) {
            System.out.println(fileName + "Read Error");
            exception.printStackTrace();
            err = true;
            byte byte0 = -1;
            return byte0;
        }
    }

    // Object擾
    static Picture get(
        int i
    ) {
        if(pictureObject == null)
            return null;
        else
            return pictureObject[i % MAX];
    }

    public Picture(String s) {
        pictureName = s;
    }

    // ]摜
    void createRotImage(
        int chr
    ) {
        for(int r=0; r<ROT_NUM; r++) {
            int tmpBuff[] = new int[rotWidth * rotHeight];

            // xS-1ŏ
            for(int y=0; y<rotHeight; y++) {
                for(int x=1; x<rotWidth-1; x++) {
                    tmpBuff[y*rotWidth + x] = -1;
                }
            }

            // ]C[W̐
            double dr = r * ROT_PREC * Math.PI / 180.0;
            for(int y=0; y<cellHeight; y++) {
                for(int x=0; x<cellWidth; x++) {
                    double posX = x - (cellWidth / 2 - 0.5);
                    double posY = y - (cellHeight / 2 - 0.5);

                    double newPosX = posX * Math.cos(dr) - posY * Math.sin(dr);
                    double newPosY = posX * Math.sin(dr) + posY * Math.cos(dr);

                    int newX = (int)(newPosX + (rotWidth / 2));
                    int newY = (int)(newPosY + (rotHeight / 2));
                    tmpBuff[newY * rotWidth + newX] = pixelArray[chr][y * cellWidth + x];
                }
            }

            // vZ덷ɂāApixelłꍇ́AP̐FgĖ߂
            for(int y=0; y<rotHeight; y++) {
                for(int x=1; x<rotWidth-1; x++) {
                    if((tmpBuff[y*rotWidth + x] == -1) &&
                       (tmpBuff[y*rotWidth + x - 1] > 0) &&
                       (tmpBuff[y*rotWidth + x + 1] > 0)) {
//                        tmpBuff[y*rotWidth + x] = (tmpBuff[y*rotWidth + x - 1] >> 1) +
//                                                  (tmpBuff[y*rotWidth + x + 1] >> 1);
                        tmpBuff[y*rotWidth + x] = tmpBuff[y*rotWidth + x - 1];
                    }
                }
            }

            // c-1̗̈̒l0ɂ
            for(int y=0; y<rotHeight; y++) {
                for(int x=0; x<rotWidth; x++) {
                    if(tmpBuff[y*rotWidth + x] == -1) {
                        tmpBuff[y*rotWidth + x] = 0;
                    }
                }
            }

//            for(int y=0; y<rotHeight; y++) {
//                for(int x=0; x<rotWidth; x++) {
//                    double posX = x - (rotWidth / 2 - 0.5);
//                    double posY = y - (rotHeight / 2 - 0.5);
//
//                    double newPosX = posX * Math.cos(-dr) - posY * Math.sin(-dr);
//                    double newPosY = posX * Math.sin(-dr) + posY * Math.cos(-dr);

//                    int newX = (int)(newPosX + (cellWidth / 2));
//                    int newY = (int)(newPosY + (cellHeight / 2));
//                    if(newX < 0 || newX >=cellWidth || newY < 0 || newY >= cellHeight) {
//                        tmpBuff[y * rotWidth + x] = 0;
//                    } else {
//                        tmpBuff[y * rotWidth + x] = pixelArray[chr][newY * cellWidth + newX];
//                    }
//                }
//            }
            pixelRotArray[chr][r] = tmpBuff;
        }
    }

    // 摜Ppixel𕪊pixelArrayɊi[
    void setPictureSource(
        int buff[],      // imagePpixel
        int imageWidth,  // image̕
        int imageHeight, // image̍
        int width,
        int height,
        int xNum,        // image̍\
        int yNum         // image̍\
    ) {
        cellWidth = width;
        cellHeight = height;

        // ClassϐpixelArraÿ̗m
        pixelArray = new int[xNum * yNum][cellWidth * cellHeight];

        if(cellWidth >= cellHeight) {
            rotWidth = (int)(cellWidth * 1.5);
            rotHeight = (int)(cellWidth * 1.5);
        } else {
            rotWidth = (int)(cellHeight * 1.5);
            rotHeight = (int)(cellHeight * 1.5);
        }

        pixelRotArray = new int[xNum * yNum][ROT_NUM][];

        // cell̐
        for(int y = 0; y < yNum; y++) {
            for(int x = 0; x < xNum; x++) {

                // ̃TCY̔z̎擾
                int tmpBuff[] = new int[cellWidth * cellHeight];
                splitPixel(buff, tmpBuff, cellWidth * x, cellHeight * y,
                           cellWidth, cellHeight, imageWidth);

                // 1cellpixelzɊi[
                pixelArray[x + y * xNum] = tmpBuff;

                loadedNum++;
            }
        }
    }

    private void splitPixel(
        int allPixel[],
        int buff[],
        int posX,
        int posY,
        int width,
        int height,
        int imageWidth
    ) {
        // Rs[index0
        int dstPtr = 0;

        for(int y = 0; y < height; y++) {
            // Rs[indexvZ
            int srcPtr = (posY + y) * imageWidth + posX;
            for(int x = 0; x < width; x++) {
                // pixel̃Rs[
                buff[dstPtr] = allPixel[srcPtr] & 0xfcfcfc;
                dstPtr++;
                srcPtr++;
            }
        }
    }

    public String toString() {
        return pictureName + ",n=" + pixelArray.length + ",w=" + cellWidth + ",h=" + cellHeight;
    }

    static final void debugOut() {
        if(pictureObject == null) {
            return;
        }
        System.out.println("Picture.debugOut");
        for(int i = 0; i < pictureObject.length; i++) {
            if(pictureObject[i] != null) {
                System.out.println(pictureObject[i]);
            }
        }
    }
}
