import java.awt.*;
import java.awt.image.*;
//import java.io.PrintStream;

public final class Render implements ImageProducer {

    // ʊ֘A`
    static final int scrnWidth = 340;
    static final int scrnHeight = 364;
    static final int bgNum = 4;

    // `䗦`
    static final int DRAW_FULL = 16;
    static final int DRAW_HALF = 8;
    static final int DRAW_50   = 8;
    static final int DRAW_75   = 12;
    static final int DRAW_25   = 4;
    static final int DRAW_06   = 1;
    static final int DRAW_12   = 2;
    static final int DRAW_18   = 3;
    static final int DRAW_31   = 5;
    static final int DRAW_37   = 6;
    static final int DRAW_43   = 7;
    static final int DRAW_56   = 9;
    static final int DRAW_62   = 10;
    static final int DRAW_68   = 11;
    static final int DRAW_81   = 13;
    static final int DRAW_87   = 14;
    static final int DRAW_93   = 15;

    // `惂[h`
    static final int DRAW_MODE_NORMAL = 0;
    static final int DRAW_MODE_ALPHA  = 1;
    static final int DRAW_MODE_ADD    = 2;

    // _O[h`
    static final int MODE_NML = 1;
    static final int MODE_DBL = 2;
    static final int MODE_SCN = 3;

    static final int scrnPixelNum = scrnWidth * scrnHeight;

    private int renderMode;

    // Zxw`揈󂯓npϐ
    static private int Alpha;
    static private int AlphaN;

    // `obt@
    // ʕ`ΏۂscrnBuff[0]łB
    private final int scrnBuff[][] = new int[bgNum][scrnPixelNum];
    private int bgNo = 0;

    private final int lineBuff[] = new int[scrnWidth];

    private final int scrnBuff2[] = new int[scrnPixelNum*4];

    private ColorModel colorModel;
    private Image scrnImage;
    private ImageConsumer imageConsumer;
    private Graphics scrGraphics;

    private boolean isStart;

    final void updateScreen() {
        if(!isStart) {
            return;
        }

        switch(renderMode) {
            case MODE_NML:
                imageConsumer.setPixels(0, 0, scrnWidth, scrnHeight,
                                        colorModel, scrnBuff[0],
                                        0, scrnWidth);
                scrGraphics.drawImage(scrnImage, 0, 0, null);
                break;
            case MODE_DBL:
                for(int y=0; y<scrnHeight; y++) {
                    for(int x=0; x<scrnWidth; x++) {
                        scrnBuff2[y*scrnWidth*4+x*2]
                            = scrnBuff[0][y*scrnWidth+x];
                        scrnBuff2[y*scrnWidth*4+x*2+1]
                            = scrnBuff[0][y*scrnWidth+x];
                        scrnBuff2[(y*2+1)*scrnWidth*2+x*2]
                            = scrnBuff[0][y*scrnWidth+x];
                        scrnBuff2[(y*2+1)*scrnWidth*2+x*2+1]
                            = scrnBuff[0][y*scrnWidth+x];
                    }
                }
                imageConsumer.setPixels(0, 0, scrnWidth*2, scrnHeight*2,
                                        colorModel, scrnBuff2, 0,
                                        scrnWidth*2);
                scrGraphics.drawImage(scrnImage, 0, 0, null);
                break;
            case MODE_SCN:
                for(int y=0; y<scrnHeight; y++) {
                    for(int x=0; x<scrnWidth; x++) {
                        scrnBuff2[y*scrnWidth*4+x*2]
                            = scrnBuff[0][y*scrnWidth+x];
                        scrnBuff2[y*scrnWidth*4+x*2+1]
                            = scrnBuff[0][y*scrnWidth+x];
                    }
                }
                imageConsumer.setPixels(0, 0, scrnWidth*2, scrnHeight*2,
                                        colorModel, scrnBuff2, 0,
                                        scrnWidth*2);
                scrGraphics.drawImage(scrnImage, 0, 0, null);
                break;
        }

        imageConsumer.imageComplete(2);

        return;
    }

    // `Ώۉʐ؂芷
    final void setBgNo() {
        bgNo = 0;
    }

    // `Ώۉʐ؂芷
    final void setBgNo(
        int no      // `Ώۉʔԍ
    ) {
        bgNo = no;
    }

    // ʃobt@
    final void init() {
        for(int j=0; j<bgNum; j++) {
            for(int i = 0; i < scrnPixelNum; i++) {
                scrnBuff[j][i] = 0;
            }
        }
    }

    // ʃobt@NA
    final void clear(
        int color   // NAF
    ) {
        for(int i = 0; i < scrnPixelNum; i++) {
            scrnBuff[bgNo][i] = color;
        }
    }

    // BGʂʃobt@100%`
    final void drawBg(
        int bg      // `ʔԍ
    ) {
        for(int i = 0; i < scrnPixelNum; i++) {
            scrnBuff[0][i] = scrnBuff[bg][i];
        }
    }

    // BGʂʃobt@֓ߓxw`
    final void drawBg(
        int bg,     // `ʔԍ
        int alpha   // ߓx
    ) {

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        if(alpha == DRAW_FULL) {
            // 100%`
            for(int i=0; i<scrnPixelNum; i++) {
                // Sɍ(0x000000)pixel͓FƂĈ
                if(scrnBuff[bg][i] != 0) {
                    scrnBuff[0][i] = scrnBuff[bg][i];
                }
            }
        } else if(alpha == DRAW_HALF) {
            // 50%`
            for(int i=0; i<scrnPixelNum; i++) {
                // Sɍ(0x000000)pixel͓FƂĈ
                if(scrnBuff[bg][i] != 0) {
                    scrnBuff[0][i] = blend50(scrnBuff[0][i], scrnBuff[bg][i]);
                }
            }
        } else if(alpha == DRAW_75) {
            // 75%`
            for(int i=0; i<scrnPixelNum; i++) {
                // Sɍ(0x000000)pixel͓FƂĈ
                if(scrnBuff[bg][i] != 0) {
                    scrnBuff[0][i] = blend75(scrnBuff[0][i], scrnBuff[bg][i]);
                }
            }
        } else if(alpha == DRAW_25) {
            // 25%`
            for(int i=0; i<scrnPixelNum; i++) {
                // Sɍ(0x000000)pixel͓FƂĈ
                if(scrnBuff[bg][i] != 0) {
                    scrnBuff[0][i] = blend25(scrnBuff[0][i], scrnBuff[bg][i]);
                }
            }
        } else {
            // ȊO̕`
            AlphaN = DRAW_FULL - alpha;
            Alpha = alpha;
            for(int i=0; i < scrnPixelNum; i++) {
                // Sɍ(0x000000)pixel͓FƂĈ
                if(scrnBuff[bg][i] != 0) {
                    scrnBuff[0][i] = blendN(scrnBuff[0][i], scrnBuff[bg][i]);
                }
            }
        }
    }

    // tF[hAEg
    final void fadeOut() {
        int r;
        int g;
        int b;
        for(int i = 0; i < scrnPixelNum; i++) {
            r = scrnBuff[bgNo][i] & 0xfe0000;
            g = scrnBuff[bgNo][i] & 0x00fe00;
            b = scrnBuff[bgNo][i] & 0x0000fe;
            if(r != 0 ) {
                r = r - 0x20000;
            }
            if(g != 0 ) {
                g = g - 0x200;
            }
            if(b != 0 ) {
                b = b - 0x2;
            }

            scrnBuff[bgNo][i] = r | g | b;
        }
    }

    // RXgN^
    public Render(
        Graphics g,     // Graphics
        int mode        // _O[h
    ) {
        isStart = false;
        scrGraphics = g;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        scrnImage = toolkit.createImage(this);

        renderMode = mode;

        switch(renderMode) {
            case MODE_NML:
                toolkit.prepareImage(scrnImage, scrnWidth, scrnHeight,
                                     null);
                break;
            case MODE_DBL:
                toolkit.prepareImage(scrnImage, scrnWidth*2, scrnHeight*2,
                                     null);
                break;
            case MODE_SCN:
                toolkit.prepareImage(scrnImage, scrnWidth*2, scrnHeight*2,
                                     null);
                break;
            default:
                toolkit.prepareImage(scrnImage, scrnWidth, scrnHeight,
                                     null);
                break;
        }
    }

    //========================================================================
    // 摜`揈
    //========================================================================
    // ʏ`
    final void drawImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `W
        int y               // `W
    ) {
        drawImageAlpha(picture.getPixel(chr), x, y,
                       picture.getWidth(), picture.getHeight(),
                       DRAW_MODE_ALPHA, DRAW_FULL, 0);
    }

    // Zxw`
    final void drawImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `W
        int y,              // `W
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        drawImageAlpha(picture.getPixel(chr), x, y, picture.getWidth(),
                       picture.getHeight(), drawmode, alpha, 0);
    }

    // ZxyѐFw`
    final void drawImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `W
        int y,              // `W
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int color           // `F
    ) {
        drawImageAlpha(picture.getPixel(chr), x, y, picture.getWidth(),
                       picture.getHeight(), drawmode, alpha, color);
    }

    //========================================================================
    // 摜`揈(SWw)
    //========================================================================
    // ʏ`
    final void drawImageCenter(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y               // `撆SW
    ) {
        drawImageAlpha(picture.getPixel(chr),
                       x - picture.getWidth()/2,
                       y - picture.getHeight()/2,
                       picture.getWidth(), picture.getHeight(),
                       DRAW_MODE_ALPHA, DRAW_FULL, 0);
    }

    // Zxw`
    final void drawImageCenter(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y,              // `撆SW
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        drawImageAlpha(picture.getPixel(chr),
                       x - picture.getWidth()/2,
                       y - picture.getHeight()/2,
                       picture.getWidth(), picture.getHeight(),
                       drawmode, alpha, 0);
    }

    // ZxyѐFw`
    final void drawImageCenter(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y,              // `撆SW
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int color           // `F
    ) {
        drawImageAlpha(picture.getPixel(chr),
                       x - picture.getWidth()/2,
                       y - picture.getHeight()/2,
                       picture.getWidth(), picture.getHeight(),
                       drawmode, alpha, color);
    }

    //========================================================================
    // ]摜`揈
    //========================================================================
    // ʏ`
    final void drawRotImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y,              // `撆SW
        int r               // `]p
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(),
                       DRAW_MODE_ALPHA, DRAW_FULL, 0);
    }

    // Zxw`
    final void drawRotImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y,              // `撆SW
        int r,              // `]p
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(),
                       drawmode, alpha, 0);
    }

    // ZxyѐFw`
    final void drawRotImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int x,              // `撆SW
        int y,              // `撆SW
        int r,              // `]p
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int color           // `F
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }
        drawImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                       x - picture.getRotWidth() / 2,
                       y - picture.getRotHeight() / 2,
                       picture.getRotWidth(), picture.getRotHeight(),
                       drawmode, alpha, color);
    }

    //========================================================================
    // gk摜`揈
    //========================================================================
    // ʏ`
    final void drawScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        double scale        // `XP[
    ) {
        drawScaledImageAlpha(picture.getPixel(chr), posX, posY,
                       picture.getWidth(), picture.getHeight(), scale,
                       DRAW_MODE_ALPHA, DRAW_FULL, 0);
    }

    // Zxw`
    final void drawScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        double scale,       // `XP[
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        drawScaledImageAlpha(picture.getPixel(chr), posX, posY,
                       picture.getWidth(), picture.getHeight(), scale,
                       drawmode, alpha, 0);
    }

    // ZxyѐFw`
    final void drawScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        double scale,       // `XP[
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int color           // `F
    ) {
        drawScaledImageAlpha(picture.getPixel(chr), posX, posY,
                       picture.getWidth(), picture.getHeight(), scale,
                       drawmode, alpha, color);
    }

    //========================================================================
    // ]gk摜`揈
    //========================================================================
    // ʏ`
    final void drawRotScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        int r,              // ]p
        double scale        // `XP[
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }

        drawScaledImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                             posX, posY,
                             picture.getRotWidth(), picture.getRotHeight(),
                             scale, DRAW_MODE_ALPHA, DRAW_FULL, 0);
    }

    // Zxw`
    final void drawRotScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        int r,              // ]p
        double scale,       // `XP[
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }

        drawScaledImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                             posX, posY,
                             picture.getRotWidth(), picture.getRotHeight(),
                             scale, drawmode, alpha, 0);
    }

    // ZxyѐFw`
    final void drawRotScaledImage(
        Picture picture,    // Picture
        int chr,            // 摜ԍ
        int posX,           // `撆SW
        int posY,           // `撆SW
        int r,              // ]p
        double scale,       // `XP[
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int color           // `F
    ) {
        if(r >= 360) {
            r = r % 360;
        }
        while(r < 0) {
            r += 360;
        }

        drawScaledImageAlpha(picture.getRotPixel(chr, r / Picture.ROT_PREC),
                             posX, posY,
                             picture.getRotWidth(), picture.getRotHeight(),
                             scale, drawmode, alpha, color);
    }

    //========================================================================
    // 4bitZxw摜`揈
    //========================================================================
    private final void drawImageAlpha(
        int pixelBuff[],    // `pixel
        int posX,           // `捶W
        int posY,           // `捶W
        int width,          // `敝
        int height,         // `捂
        int drawmode,       // `惂[h
        int alpha,          // `Zx(1..16)
        int color           // `F
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(drawmode == DRAW_MODE_NORMAL) {
            // ʏ`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = y*width;
                for(int x=x1; x < x2; x++) {
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+x] != 0) {
                        if(color == 0) {
                            scrnBuff[bgNo][dstPtr+x]
                                = pixelBuff[srcPtr+x];
                        } else {
                            scrnBuff[bgNo][dstPtr+x] = color;
                        }
                    }
                }
            }
        } else if(drawmode == DRAW_MODE_ALPHA) {
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = pixelBuff[srcPtr+x];
                            } else {
                                scrnBuff[bgNo][dstPtr+x] = color;
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend50(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend50(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_75) {
                // 75%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend75(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend75(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_25) {
                // 25%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend25(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend25(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blendN(scrnBuff[bgNo][dstPtr+x],
                                             pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blendN(scrnBuff[bgNo][dstPtr+x],
                                             color);
                            }
                        }
                    }
                }
            }
        } else {
            // PZ`
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add100(scrnBuff[bgNo][dstPtr+x],
                                             pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add100(scrnBuff[bgNo][dstPtr+x],
                                             color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add50(scrnBuff[bgNo][dstPtr+x],
                                            pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add50(scrnBuff[bgNo][dstPtr+x],
                                            color);
                            }
                        }
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+x] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = AddN(scrnBuff[bgNo][dstPtr+x],
                                           pixelBuff[srcPtr+x]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = AddN(scrnBuff[bgNo][dstPtr+x],
                                           color);
                            }
                        }
                    }
                }
            }
        }
    }

    //========================================================================
    // 4bit AlphaBlending摜gk`
    //========================================================================
    private final void drawScaledImageAlpha(
        int pixelBuff[],    // `pixel
        int cntX,           // `撆SW
        int cntY,           // `撆SW
        int width,          // `敝
        int height,         // `捂
        double scale,       // `XP[
        int drawmode,       // `惂[h
        int alpha,          // `Zx(1..16)
        int color           // `F
    ) {
        int scWidth  = (int)(width * scale + 0.5);
        int scHeight = (int)(height * scale + 0.5);

        int posX = cntX - scWidth/2;
        int posY = cntY - scHeight/2;

        if((posX+scWidth < 0) || (posY+scHeight < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = scWidth;
        y1 = 0;
        y2 = scHeight;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+scWidth) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+scHeight) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(drawmode == DRAW_MODE_NORMAL) {
            // ʏ`
            for(int y=y1; y < y2; y++) {
                int dstPtr = (posY + y) * scrnWidth + posX;
                int srcPtr = (int)(y/scale)*width;
                for(int x=x1; x < x2; x++) {
                    int tmpX = (int)(x / scale);
                    // Sɍ(0x000000)pixel͓FƂĈ
                    if(pixelBuff[srcPtr+tmpX] != 0) {
                        if(color == 0) {
                            scrnBuff[bgNo][dstPtr+x]
                                = pixelBuff[srcPtr+tmpX];
                        } else {
                            scrnBuff[bgNo][dstPtr+x] = color;
                        }
                    }
                }
            }
        } else if(drawmode == DRAW_MODE_ALPHA) {
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = pixelBuff[srcPtr+tmpX];
                            } else {
                                scrnBuff[bgNo][dstPtr+x] = color;
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend50(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend50(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_75) {
                // 75%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend75(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend75(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_25) {
                // 25%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend25(scrnBuff[bgNo][dstPtr+x],
                                              pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blend25(scrnBuff[bgNo][dstPtr+x],
                                              color);
                            }
                        }
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blendN(scrnBuff[bgNo][dstPtr+x],
                                             pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = blendN(scrnBuff[bgNo][dstPtr+x],
                                             color);
                            }
                        }
                    }
                }
            }
        } else {
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add100(scrnBuff[bgNo][dstPtr+x],
                                             pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add100(scrnBuff[bgNo][dstPtr+x],
                                             color);
                            }
                        }
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add50(scrnBuff[bgNo][dstPtr+x],
                                            pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = Add50(scrnBuff[bgNo][dstPtr+x],
                                            color);
                            }
                        }
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = (int)(y/scale)*width;
                    for(int x=x1; x < x2; x++) {
                        int tmpX = (int)(x / scale);
                        // Sɍ(0x000000)pixel͓FƂĈ
                        if(pixelBuff[srcPtr+tmpX] != 0) {
                            if(color == 0) {
                                scrnBuff[bgNo][dstPtr+x]
                                    = AddN(scrnBuff[bgNo][dstPtr+x],
                                           pixelBuff[srcPtr+tmpX]);
                            } else {
                                scrnBuff[bgNo][dstPtr+x]
                                    = AddN(scrnBuff[bgNo][dstPtr+x],
                                           color);
                            }
                        }
                    }
                }
            }
        }
    }

    //========================================================================
    // `hԂ`揈
    //========================================================================
    // Fw`
    final void fillRect(
        int x,          // `Jn_W
        int y,          // `Jn_W
        int w,          // `敝
        int h,          // `捂
        int col         // `F
    ) {
        fillRectAlpha(x, y, w, h, col, DRAW_MODE_ALPHA, DRAW_FULL);
    }

    // ZxyѐFw`
    final void fillRect(
        int x,          // `Jn_W
        int y,          // `Jn_W
        int w,          // `敝
        int h,          // `捂
        int col,        // `F
        int drawmode,   // `惂[h
        int alpha       // `Zx
    ) {
        fillRectAlpha(x, y, w, h, col, drawmode, alpha);
    }

    //========================================================================
    // 4bitZxw`hԂ`
    //========================================================================
    private final void fillRectAlpha(
        int posX,       // `W
        int posY,       // `W
        int width,      // `敝
        int height,     // `捂
        int color,      // `F
        int drawmode,   // `惂[h
        int alpha       // `Zx(1..16)
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(drawmode == DRAW_MODE_ALPHA) {
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x] = color;
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = blend50(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            } else if(alpha == DRAW_75) {
                // 75%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = blend75(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            } else if(alpha == DRAW_25) {
                // 25%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = blend25(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = blendN(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            }
        } else {
            if(alpha == DRAW_FULL) {
                // PZ`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = Add100(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 25%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = Add50(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    for(int x=x1; x < x2; x++) {
                        scrnBuff[bgNo][dstPtr+x]
                            = AddN(scrnBuff[bgNo][dstPtr+x], color);
                    }
                }
            }
        }
    }

    //========================================================================
    // ``揈
    //========================================================================
    // Fw`
    final void drawRect(
        int x,
        int y,
        int w,
        int h,
        int col
    ) {
        drawRectAlpha(x, y, w, h, col, DRAW_MODE_ALPHA, DRAW_FULL);
    }

    // ZxyѐFw`
    final void drawRect(
        int x,
        int y,
        int w,
        int h,
        int col,
        int drawmode,
        int alpha
    ) {
        drawRectAlpha(x, y, w, h, col, drawmode, alpha);
    }

    //========================================================================
    // 4bitZxw``
    //========================================================================
    private final void drawRectAlpha(
        int posX,           // `W
        int posY,           // `W
        int width,          // `敝
        int height,         // `捂
        int color,          // `F
        int drawmode,       // `惂[h
        int alpha           // alphal(1..16)
    ) {
        if((posX+width < 0) || (posY+height < 0) ||
           (posX >= scrnWidth) || (posY >= scrnHeight)) {
            return;
        }

        if((alpha <= 0) || (alpha > DRAW_FULL)) {
            return;
        }

        int y1;
        int y2;
        int x1;
        int x2;
        x1 = 0;
        x2 = width;
        y1 = 0;
        y2 = height;
        if(posX < 0) {
            x1 = -posX;
        }
        if((posX+width) >= scrnWidth) {
            x2 = scrnWidth - posX;
        }
        if(posY < 0) {
            y1 = -posY;
        }
        if((posY+height) >= scrnHeight) {
            y2 = scrnHeight - posY;
        }

        if(color != 0) {
            color = color & 0x00fcfcfc;
        }

        if(drawmode == DRAW_MODE_ALPHA) {
            if(alpha == DRAW_FULL) {
                // 100%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x] = color;
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1] = color;
                        scrnBuff[bgNo][dstPtr+x2-1] = color;
                    }
                }
            } else if(alpha == DRAW_HALF) {
                // 50%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = blend50(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = blend50(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = blend50(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            } else if(alpha == DRAW_75) {
                // 75%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = blend75(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = blend75(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = blend75(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            } else if(alpha == DRAW_25) {
                // 25%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = blend25(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = blend25(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = blend25(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = blendN(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = blendN(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = blendN(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            }
        } else {
            if(alpha == DRAW_FULL) {
                // PZ`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = Add100(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = Add100(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = Add100(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            } else if(alpha == DRAW_50) {
                // 75%`
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = Add50(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = Add50(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = Add50(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            } else {
                // ȊO̕`
                AlphaN = DRAW_FULL - alpha;
                Alpha = alpha;
                for(int y=y1; y < y2; y++) {
                    int dstPtr = (posY + y) * scrnWidth + posX;
                    int srcPtr = y*width;
                    if((y == y1) || (y == y2-1)) {
                        for(int x=x1; x < x2; x++) {
                            scrnBuff[bgNo][dstPtr+x]
                                = AddN(scrnBuff[bgNo][dstPtr+x], color);
                        }
                    } else {
                        scrnBuff[bgNo][dstPtr+x1]
                            = AddN(scrnBuff[bgNo][dstPtr+x1], color);
                        scrnBuff[bgNo][dstPtr+x2-1]
                            = AddN(scrnBuff[bgNo][dstPtr+x2-1], color);
                    }
                }
            }
        }
    }

    //========================================================================
    // At@ufBOvZ
    //========================================================================
    // 50%
    static final int blend50(
        int col1,
        int col2
    ) {
        return ((col1 & 0xfefefe) >> 1) + (col2 >> 1);
    }

    // 75%
    static final int blend75(
        int col1,
        int col2
    ) {
        return ((col1 & 0xfcfcfc) >> 2) + col2 - (col2 >> 2);
    }

    // 25%
    static final int blend25(
        int col1,
        int col2
    ) {
        return col1 - ((col1 & 0xfcfcfc) >> 2) + (col2 >> 2);
    }

    // CӔ䗦
    static final int blendN(
        int col1,
        int col2
    ) {
        int col = ((col1 & 0xff00ff) * AlphaN + (col2 & 0xff00ff) * Alpha) &
                  0x0ff00ff0;
        col |= ((col1 & 0x00ff00) * AlphaN + (col2 & 0x00ff00) * Alpha) &
                0x000ff000;

        return col >> 4;
    }

    //========================================================================
    // PZvZ
    //========================================================================
    // 100%
    static final int Add100(
        int col1,
        int col2
    ) {
        int r;
        int g;
        int b;

        r = (col1 & 0xff0000) + (col2 & 0xff0000);
        g = (col1 & 0x00ff00) + (col2 & 0x00ff00);
        b = (col1 & 0x0000ff) + (col2 & 0x0000ff);

        if(r > 0xff0000) r = 0xff0000;
        if(g > 0x00ff00) g = 0x00ff00;
        if(b > 0x0000ff) b = 0x0000ff;

        return r | g | b;
    }

    // 50%
    static final int Add50(
        int col1,
        int col2
    ) {
        int r;
        int g;
        int b;

        r = (col1 & 0xff0000) + (((col2 & 0xff0000) >> 1) & 0xff0000);
        g = (col1 & 0x00ff00) + (((col2 & 0x00ff00) >> 1) & 0x00ff00);
        b = (col1 & 0x0000ff) +  ((col2 & 0x0000ff) >> 1);

        if(r > 0xff0000) r = 0xff0000;
        if(g > 0x00ff00) g = 0x00ff00;
        if(b > 0x0000ff) b = 0x0000ff;

        return r | g | b;
    }

    // CӔ䗦
    static final int AddN(
        int col1,
        int col2
    ) {
        int r;
        int g;
        int b;

        r = (col1 & 0xff0000)
            + ((((col2 & 0xff0000) * Alpha) >> 4) & 0xff0000);
        g = (col1 & 0x00ff00)
            + ((((col2 & 0x00ff00) * Alpha) >> 4) & 0x00ff00);
        b = (col1 & 0x0000ff)
            +  (((col2 & 0x0000ff) * Alpha) >> 4);

        if(r > 0xff0000) r = 0xff0000;
        if(g > 0x00ff00) g = 0x00ff00;
        if(b > 0x0000ff) b = 0x0000ff;

        return r | g | b;
    }

    //========================================================================
    // wsNZ`
    //========================================================================
    final void drawPixels(
        int posX[],     // `悘Wz
        int posY[],     // `悙Wz
        int color[],    // `Fz
        int pNum        // `_
    ) {
        for(int i = 0; i<pNum; i++) {
            scrnBuff[bgNo][posY[i] * scrnWidth + posX[i]] = color[i];
        }
    }

    //========================================================================
    // X^XN[
    //========================================================================
    final void rasterScroll(
        int vLine,  // XN[C
        int hPos    // `Jnʒu
    ) {
        int pos;
        if(hPos < 0) {
            pos = scrnWidth+hPos;
        } else {
            pos = hPos;
        }

        if(pos < 0 || pos >= scrnWidth) {
            return;
        }

        int scrnPtr = vLine * scrnWidth;
        int i;
        for(i=0; i<pos; i++) {
            lineBuff[i] = scrnBuff[bgNo][scrnPtr+i];
        }
        for(i=0; i<scrnWidth - pos; i++) {
            scrnBuff[bgNo][scrnPtr+i] = scrnBuff[bgNo][scrnPtr+pos+i];
        }
        for(i=0; i<pos; i++) {
            scrnBuff[bgNo][scrnPtr+scrnWidth-pos+i] = lineBuff[i];
        }
    }

    //========================================================================
    // `揈
    //========================================================================
    // ʏ`
    final void drawString(
        Picture picture,    // Picture
        int x,              // `W
        int y,              // `W
        String str          // `敶
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w, y, w, h,
                           DRAW_MODE_ALPHA, DRAW_FULL, 0);
        }
    }

    // Zxw`
    final void drawString(
        Picture picture,    // Picture
        int x,              // `W
        int y,              // `W
        String str,         // `敶
        int drawmode,       // `惂[h
        int alpha           // `Zx
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w, y, w, h,
                           drawmode, alpha, 0);
        }
    }

    // ZxyѐFw`
    final void drawString(
        Picture picture,    // Picture
        int x,              // `W
        int y,              // `W
        String str,         // `敶
        int drawmode,       // `惂[h
        int alpha,          // `Zx
        int col             // `F
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w, y, w, h,
                           drawmode, alpha, col);
        }
    }

    //========================================================================
    // gk`揈
    //========================================================================
    // Zxw
    final void drawScaledString(
        Picture picture,
        int x,
        int y,
        String str,
        double scale,
        int drawmode,
        int alpha
    ) {
        int ch;
        int w = picture.getWidth();
        double strWidth = (int)(str.length() * w * scale);
        int strHeight = (int)(picture.getHeight() * scale);
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawScaledImage(picture, ch,
                            (int)(x-strWidth/2+(i+0.5)*w*scale),
                            y-strHeight/2, scale, drawmode, alpha);
        }
    }

    //========================================================================
    // `揈(SWw)
    //========================================================================
    // Zxw`
    final void drawStringCenter(
        Picture picture,
        int x,
        int y,
        String str,
        int drawmode,
        int alpha
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        int strWidth = str.length() * w;
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x+i*w-strWidth/2, y-h/2,
                           w, h, drawmode, alpha, 0);
        }
    }

    // ZxyѐFw`
    final void drawStringCenter(
        Picture picture,
        int x,
        int y,
        String str,
        int drawmode,
        int alpha,
        int col
    ) {
        int ch;
        int w = picture.getWidth();
        int h = picture.getHeight();
        int strWidth = str.length() * w;
        for(int i=0; i<str.length(); i++) {
            ch = (int)str.charAt(i);
            drawImageAlpha(picture.getPixel(ch), x-strWidth/2+i*w, y-h/2,
                           w, h, drawmode, alpha, col);
        }
    }

    //========================================================================
    // Line`揈
    //========================================================================
    final void drawLineX(
        int x1,
        int x2,
        int y,
        int color,
        int alpha
    ) {
        // `͈̓`FbN
        if(y < 0 || y >= scrnHeight) {
            return;
        }
        if(x1 > x2) {
            return;
        }

        if(x1 < 0) {
            x1 = 0;
        }
        if(x2 >= scrnWidth) {
            x2 = scrnWidth;
        }

        if(alpha == DRAW_FULL) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[bgNo][y * scrnWidth + x] = color;
            }
        } else if(alpha == DRAW_HALF) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend50(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else if(alpha == DRAW_75) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend75(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else if(alpha == DRAW_25) {
            for(int x=x1; x<x2; x++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend25(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else {
            AlphaN = DRAW_FULL - alpha;
            Alpha = alpha;
            for(int x=x1; x<x2; x++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blendN(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        }
    }

    //========================================================================
    // cLine`揈
    //========================================================================
    final void drawLineY(
        int x,
        int y1,
        int y2,
        int color,
        int alpha
    ) {
        // `͈̓`FbN
        if(x < 0 || x >= scrnWidth) {
            return;
        }
        if(y1 > y2) {
            return;
        }

        if(y1 < 0) {
            y1 = 0;
        }
        if(y2 >= scrnHeight) {
            y2 = scrnHeight;
        }

        if(alpha == DRAW_FULL) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[bgNo][y * scrnWidth + x] = color;
            }
        } else if(alpha == DRAW_HALF) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend50(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else if(alpha == DRAW_75) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend75(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else if(alpha == DRAW_25) {
            for(int y=y1; y<y2; y++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blend25(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        } else {
            AlphaN = DRAW_FULL - alpha;
            Alpha = alpha;
            for(int y=y1; y<y2; y++) {
                scrnBuff[bgNo][y * scrnWidth + x]
                    = blendN(scrnBuff[bgNo][y * scrnWidth + x], color);
            }
        }
    }

    //========================================================================
    // 16bit Line`揈
    //========================================================================
    final void drawLine16(
        int x1,     // n_W
        int y1,     // n_W
        int x2,     // I_W
        int y2,     // I_W
        int color,  // `F
        int drawmode
    ) {
        int xChkFlag = 0;
        int yChkFlag = 0;

        // `̈攻
        if(x1 < 0)             xChkFlag |= 1;
        if(x1 >= scrnWidth)  xChkFlag |= 2;
        if(y1 < 0)             xChkFlag |= 4;
        if(y1 >= scrnHeight) xChkFlag |= 8;
        if(x2 < 0)             yChkFlag |= 1;
        if(x2 >= scrnWidth)  yChkFlag |= 2;
        if(y2 < 0)             yChkFlag |= 4;
        if(y2 >= scrnHeight) yChkFlag |= 8;

        if((xChkFlag & yChkFlag) != 0) {
            return;
        } else {
            drawline(x1 << 16, y1 << 16, x2 << 16, y2 << 16, color, drawmode);
            return;
        }
    }

    private final void drawline(
        int x1,     // n_W(16bitVtg)
        int y1,     // n_W(16bitVtg)
        int x2,     // I_W(16bitVtg)
        int y2,     // I_W(16bitVtg)
        int color,  // `F
        int drawmode
    ) {
        int xDiff = Math.abs((x2 >> 16) - (x1 >> 16));
        int yDiff = Math.abs((y2 >> 16) - (y1 >> 16));

        if(xDiff < yDiff) {
            if(yDiff == 0) {
                yDiff++;
            }

            int xAdd = (x2 - x1) / yDiff;
            int yAdd = (y2 - y1) >> 31 | 1;
            y1 = y1 >> 16;

            for(int yLoop = 0; yLoop < yDiff; yLoop++) {
                int xTmp = x1 >> 16;

                if(xTmp >= 0 &&
                   xTmp < (scrnWidth - 1) &&
                   y1 >= 0 &&
                   y1 < (scrnHeight - 1)) {
                    int scrnPtr = y1 * scrnWidth + xTmp;
                    int xCalc = (x1 >> 8) & 0xff;
                    scrnBuff[bgNo][scrnPtr]
                        = calcPixelColor(scrnBuff[bgNo][scrnPtr],
                                         color, xCalc, drawmode);
                    scrnBuff[bgNo][scrnPtr + 1]
                        = calcPixelColor(scrnBuff[bgNo][scrnPtr + 1],
                                         color, 0xff - xCalc, drawmode);
                }

                x1 += xAdd;
                y1 += yAdd;
            }
        } else {
            if(xDiff == 0) {
                xDiff++;
            }

            int yAdd = (y2 - y1) / xDiff;
            int xAdd = (x2 - x1) >> 31 | 1;
            x1 = x1 >> 16;

            for(int xLoop = 0; xLoop < xDiff; xLoop++) {
                int yTmp = y1 >> 16;

                if(yTmp >= 0 &&
                   yTmp < (scrnHeight - 1) &&
                   x1 >= 0 &&
                   x1 < (scrnWidth - 1)) {
                    int scrnPtr = yTmp * scrnWidth + x1;
                    int yCalc = (y1 >> 8) & 0xff;
                    scrnBuff[bgNo][scrnPtr]
                        = calcPixelColor(scrnBuff[bgNo][scrnPtr],
                                         color, yCalc, drawmode);
                    scrnBuff[bgNo][scrnPtr + scrnWidth]
                        = calcPixelColor(scrnBuff[bgNo][scrnPtr + scrnWidth],
                                         color, 0xff - yCalc, drawmode);
                }

                x1 += xAdd;
                y1 += yAdd;
            }
        }
    }

    // 16bit Line`ppixelvZ
    private static final int calcPixelColor(
        int baseColor,
        int drawColor,
        int blend,
        int drawmode
    ) {
        int blendN = 0xff - blend;

        int newColor;
        if(drawmode == DRAW_MODE_ADD) {
            int newColR;
            int newColG;
            int newColB;
            newColR  = (baseColor & 0xff0000)
                        + (drawColor & 0xff0000);
            newColG  = (baseColor & 0x00ff00)
                        + (drawColor & 0x00ff00);
            newColB  = (baseColor & 0x0000ff)
                        + (drawColor & 0x0000ff);

            if(newColR > 0xff0000) newColR = 0xff0000;
            if(newColG > 0x00ff00) newColG = 0x00ff00;
            if(newColB > 0x0000ff) newColB = 0x0000ff;

            newColor = newColR | newColG | newColB;
        } else {
            newColor  = (baseColor & 0xff0000) * blend
                      + (drawColor & 0xff0000) * blendN & 0xff000000;
            newColor |= (baseColor & 0x00ff00) * blend
                      + (drawColor & 0x00ff00) * blendN & 0x00ff0000;
            newColor |= (baseColor & 0x0000ff) * blend
                      + (drawColor & 0x0000ff) * blendN;
            newColor = newColor >> 8;
        }
        return newColor;
    }

    //========================================================================
    // Image
    //========================================================================
    public final void startProduction(
        ImageConsumer imageconsumer
    ) {
        colorModel = new DirectColorModel(24, 0xff0000, 0x00ff00, 0x0000ff);
        imageConsumer = imageconsumer;

        switch (renderMode) {
            case MODE_NML:
                imageConsumer.setDimensions(scrnWidth, scrnHeight);
                break;
            case MODE_DBL:
                imageConsumer.setDimensions(scrnWidth*2, scrnHeight*2);
                break;
            case MODE_SCN:
                imageConsumer.setDimensions(scrnWidth*2, scrnHeight*2);
                break;
        }
        imageConsumer.setColorModel(colorModel);
        Render _tmp = this;
        imageConsumer.setHints(
            // 2:sNZ̓C[W̏ォ牺AȄőB
            ImageConsumer.TOPDOWNLEFTRIGHT |
            // 4:sNZ͍s(XLC)PʂőBs܂Ƃ߂
            //   邩ȂAs̓r܂ł𑗂邱Ƃ͂ȂB
            ImageConsumer.COMPLETESCANLINES |
            // 8:ꏊ̃sNZ2ȏ㑗邱Ƃ͂ȂB
            ImageConsumer.SINGLEPASS |
            // 16:C[W͂P̃t[łĂB
            ImageConsumer.SINGLEFRAME
        );
        isStart = true;
    }

    public final void addConsumer(
        ImageConsumer imageconsumer
    ) {
        System.out.println("!addConsumer");
    }

    public final boolean isConsumer(
        ImageConsumer imageconsumer
    ) {
        System.out.println("!isConsumer");
        return false;
    }

    public final void removeConsumer(
        ImageConsumer imageconsumer
    ) {
        System.out.println("!removeConsumer");
    }

    public final void requestTopDownLeftRightResend(
        ImageConsumer imageconsumer
    ) {
        System.out.println("!requestTopDownLeftRightResend");
    }

    public final void paint(Graphics g) {
        drawScreen();
    }

    public final void repaint() {
        drawScreen();
    }

    public final void update(Graphics g) {
        drawScreen();
    }

    private final void drawScreen() {
        updateScreen();
    }
}
