/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;

final class Picture {
    static boolean err;
    private static int loadedNum;
    private static Applet baseApplet;
    private static MediaTracker mt;
    private static Picture[] pictureObject;
    static final int MAX = 16;
    private static int pictureCounter;
    private String pictureName;
    private int[][] pixelArray;
    private int[][][] pixelRotArray;
    private int rotWidth;
    private int rotHeight;
    static final int ROT_NUM = 72;
    static final int DEGREE = 360;
    static final int ROT_PREC = 5;
    private int cellWidth;
    private int cellHeight;

    final String getName() {
        return this.pictureName;
    }

    final int getNum() {
        return this.pixelArray.length;
    }

    final int[] getPixel(int n) {
        return this.pixelArray[n];
    }

    final int getWidth() {
        return this.cellWidth;
    }

    final int getHeight() {
        return this.cellHeight;
    }

    final int[] getRotPixel(int n, int n2) {
        return this.pixelRotArray[n][n2];
    }

    final int getRotWidth() {
        return this.rotWidth;
    }

    final int getRotHeight() {
        return this.rotHeight;
    }

    static void init(Applet applet) {
        System.out.println("Picture.init");
        baseApplet = applet;
        mt = new MediaTracker(applet);
        pictureObject = new Picture[16];
        pictureCounter = 0;
        loadedNum = 1;
        err = false;
    }

    static void release() {
        System.out.println("Picture.release");
        pictureObject = null;
        System.gc();
    }

    static int create(String string, int n, int n2, int n3, int n4) {
        try {
            int n5 = 0;
            while (n5 < 16 && pictureObject[n5] != null && Picture.pictureObject[n5].pictureName != null) {
                if (Picture.pictureObject[n5].pictureName.equals(string)) {
                    return n5;
                }
                ++n5;
            }
            System.out.println(string);
            Image image = baseApplet.getImage(baseApplet.getCodeBase(), string);
            mt.addImage(image, 0);
            mt.waitForID(0);
            int n6 = image.getWidth(null);
            int n7 = image.getHeight(null);
            if (n6 <= 0 || n7 <= 0) {
                throw new Exception("Cannot read " + string);
            }
            int[] nArray = new int[n6 * n7];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, nArray, 0, n6);
            pixelGrabber.grabPixels();
            pixelGrabber = null;
            image.flush();
            System.gc();
            Picture picture = new Picture(string);
            picture.setPictureSource(nArray, n6, n7, n, n2, n3, n4);
            int n8 = pictureCounter++;
            Picture.pictureObject[n8] = picture;
            return n8;
        }
        catch (Exception exception) {
            System.out.println(string + "Read Error");
            exception.printStackTrace();
            err = true;
            int n9 = -1;
            return n9;
        }
    }

    static Picture get(int n) {
        if (pictureObject == null) {
            return null;
        }
        return pictureObject[n % 16];
    }

    public Picture(String string) {
        this.pictureName = string;
    }

    void createRotImage(int n) {
        int n2 = 0;
        while (n2 < 72) {
            int n3;
            int[] nArray = new int[this.rotWidth * this.rotHeight];
            int n4 = 0;
            while (n4 < this.rotHeight) {
                int n5 = 0;
                while (n5 < this.rotWidth) {
                    nArray[n4 * this.rotWidth + n5] = -1;
                    ++n5;
                }
                ++n4;
            }
            double d = (double)(n2 * 5) * Math.PI / 180.0;
            int n6 = 0;
            while (n6 < this.cellHeight) {
                n3 = 0;
                while (n3 < this.cellWidth) {
                    double d2 = (double)n3 - ((double)(this.cellWidth / 2) - 0.5);
                    double d3 = (double)n6 - ((double)(this.cellHeight / 2) - 0.5);
                    double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
                    double d5 = d2 * Math.sin(d) + d3 * Math.cos(d);
                    int n7 = (int)(d4 + (double)(this.rotWidth / 2));
                    int n8 = (int)(d5 + (double)(this.rotHeight / 2));
                    nArray[n8 * this.rotWidth + n7] = this.pixelArray[n][n6 * this.cellWidth + n3];
                    ++n3;
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < this.rotHeight) {
                int n9 = 1;
                while (n9 < this.rotWidth - 1) {
                    if (nArray[n3 * this.rotWidth + n9] == -1 && nArray[n3 * this.rotWidth + n9 - 1] > 0 && nArray[n3 * this.rotWidth + n9 + 1] > 0) {
                        nArray[n3 * this.rotWidth + n9] = nArray[n3 * this.rotWidth + n9 - 1];
                    }
                    ++n9;
                }
                ++n3;
            }
            int n10 = 0;
            while (n10 < this.rotHeight) {
                int n11 = 0;
                while (n11 < this.rotWidth) {
                    if (nArray[n10 * this.rotWidth + n11] == -1) {
                        nArray[n10 * this.rotWidth + n11] = 0;
                    }
                    ++n11;
                }
                ++n10;
            }
            this.pixelRotArray[n][n2] = nArray;
            ++n2;
        }
    }

    void setPictureSource(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.cellWidth = n3;
        this.cellHeight = n4;
        this.pixelArray = new int[n5 * n6][this.cellWidth * this.cellHeight];
        if (this.cellWidth >= this.cellHeight) {
            this.rotWidth = (int)((double)this.cellWidth * 1.5);
            this.rotHeight = (int)((double)this.cellWidth * 1.5);
        } else {
            this.rotWidth = (int)((double)this.cellHeight * 1.5);
            this.rotHeight = (int)((double)this.cellHeight * 1.5);
        }
        this.pixelRotArray = new int[n5 * n6][72][];
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                int[] nArray2 = new int[this.cellWidth * this.cellHeight];
                this.splitPixel(nArray, nArray2, this.cellWidth * n8, this.cellHeight * n7, this.cellWidth, this.cellHeight, n);
                this.pixelArray[n8 + n7 * n5] = nArray2;
                ++loadedNum;
                ++n8;
            }
            ++n7;
        }
    }

    private void splitPixel(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = (n2 + n7) * n5 + n;
            int n9 = 0;
            while (n9 < n3) {
                nArray2[n6] = nArray[n8] & 0xFCFCFC;
                ++n6;
                ++n8;
                ++n9;
            }
            ++n7;
        }
    }

    public String toString() {
        return this.pictureName + ",n=" + this.pixelArray.length + ",w=" + this.cellWidth + ",h=" + this.cellHeight;
    }

    static final void debugOut() {
        if (pictureObject == null) {
            return;
        }
        System.out.println("Picture.debugOut");
        int n = 0;
        while (n < pictureObject.length) {
            if (pictureObject[n] != null) {
                System.out.println(pictureObject[n]);
            }
            ++n;
        }
    }
}

