import java.awt.*;

public final class Chaser extends Enemy {

    //========================================================================
    // NXϐ`
    //========================================================================
    private static final int gid = Enemy.CHASER;
    private static final double spd = 3.0;

    private static final int num = 8;                  // 
    private static final int life = 360;               // 
    private static final int hp = -1;                  // ϋvx
    private static final double size = 2.0;            // TCY

    private static final int power = 6;                // З
    private static final int points = 0;               // _

    static Picture pict;
    static int pictId;
    static Render render;

    static final int hNum = 6;
    private int posXH[] = new int[hNum];
    private int posYH[] = new int[hNum];
    static int al[] = new int[hNum];

    //========================================================================
    // CX^Xϐ`
    //========================================================================
    private int eid;
    private int cntr;

    //========================================================================
    // ÓI
    //========================================================================
    static {
        al[0] = 16;
        al[1] = 8;
        al[2] = 8;
        al[3] = 4;
        al[4] = 4;
        al[5] = 4;
    }

    //========================================================================
    // RXgN^
    //========================================================================
    Chaser(Render rend, Picture picture, int picId) {
        super(0.0, 0.0, size);

        render = rend;
        pict = picture;
        pictId = picId;
    }

    //========================================================================
    // Method
    //========================================================================
    // 擾
    static public int getNum() {
        return num;
    }

    // ʕ\
    public final void draw(
    ) {
        for(int i=hNum-1; i>0; i--) {
            posXH[i] = posXH[i-1];
            posYH[i] = posYH[i-1];
        }
        posXH[0] = (int)getPosX();
        posYH[0] = (int)getPosY();

        for(int i=0; i<hNum; i++) {
            render.drawImageCenter(pict, pictId, posXH[i], posYH[i], Render.DRAW_MODE_ALPHA, al[i]);
        }
    }
    public final void draw(
        int      col
    ) {
        render.drawImageCenter(pict, pictId, (int)getPosX(), (int)getPosY(), Render.DRAW_MODE_ALPHA, Render.DRAW_FULL);
//        render.drawImageCenter(pict, pictId, (int)getPosX(), (int)getPosY(), Render.DRAW_MODE_ADD, Render.DRAW_FULL);
    }

    public final int getGid() {
        return gid;
    }

    public final int getEid() {
        return eid;
    }

    public final void setEid(int id) {
        eid = id;
    }

    public final int getPts() {
        return points;
    }

    public final int getPow() {
        return power;
    }

    // JE^CNg
    public final void incCntr() {
        cntr++;
    }

    // JE^擾
    public final int getCntr() {
        return cntr;
    }

    // 
    public void init(double posx, double posy, int vec) {
        setPos(posx, posy);
        setLife(life);
        setHp(hp);
        setVelTh(0);
        setVecTh(vec);
        setVec(vec, spd);
        setScale(1.0);

        for(int i=0; i<hNum; i++) {
            posXH[i] = (int)posx;
            posYH[i] = (int)posy;
        }
    }
}
