/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public final class Render
implements ImageProducer {
    int scrnWidth;
    int scrnHeight;
    int bgNum;
    static final int DRAW_FULL = 16;
    static final int DRAW_HALF = 8;
    static final int DRAW_50 = 8;
    static final int DRAW_75 = 12;
    static final int DRAW_25 = 4;
    static final int DRAW_06 = 1;
    static final int DRAW_12 = 2;
    static final int DRAW_18 = 3;
    static final int DRAW_31 = 5;
    static final int DRAW_37 = 6;
    static final int DRAW_43 = 7;
    static final int DRAW_56 = 9;
    static final int DRAW_62 = 10;
    static final int DRAW_68 = 11;
    static final int DRAW_81 = 13;
    static final int DRAW_87 = 14;
    static final int DRAW_93 = 15;
    static final int DRAW_MODE_NORMAL = 0;
    static final int DRAW_MODE_ALPHA = 1;
    static final int DRAW_MODE_ADD = 2;
    static final int MODE_NML = 1;
    static final int MODE_DBL = 2;
    static final int MODE_SCN = 3;
    private int renderMode;
    private int Alpha;
    private int AlphaN;
    private int bgNo = 0;
    private final int scrnPixelNum;
    private final int[][] scrnBuff;
    private final int[] lineBuff;
    private final int[] scrnBuff2;
    private ColorModel colorModel;
    private Image scrnImage;
    private ImageConsumer imageConsumer;
    private Graphics scrGraphics;
    private boolean isStart = false;

    public Render(Graphics graphics, int n, int n2, int n3, int n4) {
        this.scrGraphics = graphics;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.scrnImage = toolkit.createImage(this);
        this.renderMode = n;
        this.scrnWidth = n2;
        this.scrnHeight = n3;
        this.bgNum = n4;
        this.scrnPixelNum = this.scrnWidth * this.scrnHeight;
        this.scrnBuff = new int[this.bgNum][this.scrnPixelNum];
        this.lineBuff = new int[this.scrnWidth];
        switch (this.renderMode) {
            case 1: {
                this.scrnBuff2 = new int[0];
                toolkit.prepareImage(this.scrnImage, this.scrnWidth, this.scrnHeight, null);
                break;
            }
            case 2: {
                this.scrnBuff2 = new int[this.scrnPixelNum * 4];
                toolkit.prepareImage(this.scrnImage, this.scrnWidth * 2, this.scrnHeight * 2, null);
                break;
            }
            case 3: {
                this.scrnBuff2 = new int[this.scrnPixelNum * 4];
                toolkit.prepareImage(this.scrnImage, this.scrnWidth * 2, this.scrnHeight * 2, null);
                break;
            }
            default: {
                this.scrnBuff2 = new int[0];
                toolkit.prepareImage(this.scrnImage, this.scrnWidth, this.scrnHeight, null);
            }
        }
    }

    final void updateScreen() {
        if (!this.isStart) {
            return;
        }
        switch (this.renderMode) {
            case 1: {
                this.imageConsumer.setPixels(0, 0, this.scrnWidth, this.scrnHeight, this.colorModel, this.scrnBuff[0], 0, this.scrnWidth);
                this.scrGraphics.drawImage(this.scrnImage, 0, 0, null);
                break;
            }
            case 2: {
                int n = this.scrnHeight - 1;
                while (n >= 0) {
                    int n2 = this.scrnWidth - 1;
                    while (n2 >= 0) {
                        this.scrnBuff2[n * this.scrnWidth * 4 + n2 * 2] = this.scrnBuff[0][n * this.scrnWidth + n2];
                        this.scrnBuff2[n * this.scrnWidth * 4 + n2 * 2 + 1] = this.scrnBuff[0][n * this.scrnWidth + n2];
                        this.scrnBuff2[(n * 2 + 1) * this.scrnWidth * 2 + n2 * 2] = this.scrnBuff[0][n * this.scrnWidth + n2];
                        this.scrnBuff2[(n * 2 + 1) * this.scrnWidth * 2 + n2 * 2 + 1] = this.scrnBuff[0][n * this.scrnWidth + n2];
                        --n2;
                    }
                    --n;
                }
                this.imageConsumer.setPixels(0, 0, this.scrnWidth * 2, this.scrnHeight * 2, this.colorModel, this.scrnBuff2, 0, this.scrnWidth * 2);
                this.scrGraphics.drawImage(this.scrnImage, 0, 0, null);
                break;
            }
            case 3: {
                int[] nArray = this.scrnBuff[0];
                int[] nArray2 = this.scrnBuff2;
                int n = this.scrnHeight - 1;
                while (n >= 0) {
                    int n3 = n * this.scrnWidth * 4;
                    int n4 = n * this.scrnWidth;
                    int n5 = this.scrnWidth - 1;
                    while (n5 >= 0) {
                        nArray2[n3 + n5 * 2] = nArray[n4 + n5];
                        nArray2[n3 + n5 * 2 + 1] = nArray[n4 + n5];
                        --n5;
                    }
                    --n;
                }
                this.imageConsumer.setPixels(0, 0, this.scrnWidth * 2, this.scrnHeight * 2, this.colorModel, nArray2, 0, this.scrnWidth * 2);
                this.scrGraphics.drawImage(this.scrnImage, 0, 0, null);
            }
        }
        this.imageConsumer.imageComplete(2);
    }

    final void setBgNo() {
        this.bgNo = 0;
    }

    final void setBgNo(int n) {
        this.bgNo = n;
    }

    final void init() {
        int n = this.bgNum - 1;
        while (n >= 0) {
            int n2 = this.scrnPixelNum - 1;
            while (n2 >= 0) {
                this.scrnBuff[n][n2] = 0;
                --n2;
            }
            --n;
        }
    }

    final void clear(int n) {
        int n2 = this.scrnPixelNum - 1;
        while (n2 >= 0) {
            this.scrnBuff[this.bgNo][n2] = n;
            --n2;
        }
    }

    final void drawBg(int n) {
        System.arraycopy(this.scrnBuff[n], 0, this.scrnBuff[0], 0, this.scrnPixelNum);
    }

    final void drawBg(int n, int n2) {
        if (n2 <= 0 || n2 > 16) {
            return;
        }
        if (n2 == 16) {
            System.arraycopy(this.scrnBuff[n], 0, this.scrnBuff[0], 0, this.scrnPixelNum);
        } else if (n2 == 8) {
            int n3 = this.scrnPixelNum - 1;
            while (n3 >= 0) {
                if (this.scrnBuff[n][n3] != 0) {
                    this.scrnBuff[0][n3] = Render.blend50(this.scrnBuff[0][n3], this.scrnBuff[n][n3]);
                }
                --n3;
            }
        } else if (n2 == 12) {
            int n4 = this.scrnPixelNum - 1;
            while (n4 >= 0) {
                if (this.scrnBuff[n][n4] != 0) {
                    this.scrnBuff[0][n4] = Render.blend75(this.scrnBuff[0][n4], this.scrnBuff[n][n4]);
                }
                --n4;
            }
        } else if (n2 == 4) {
            int n5 = this.scrnPixelNum - 1;
            while (n5 >= 0) {
                if (this.scrnBuff[n][n5] != 0) {
                    this.scrnBuff[0][n5] = Render.blend25(this.scrnBuff[0][n5], this.scrnBuff[n][n5]);
                }
                --n5;
            }
        } else {
            this.AlphaN = 16 - n2;
            this.Alpha = n2;
            int n6 = this.scrnPixelNum - 1;
            while (n6 >= 0) {
                if (this.scrnBuff[n][n6] != 0) {
                    this.scrnBuff[0][n6] = this.blendN(this.scrnBuff[0][n6], this.scrnBuff[n][n6]);
                }
                --n6;
            }
        }
    }

    final void fadeOut() {
        int[] nArray = this.scrnBuff[this.bgNo];
        int n = this.scrnPixelNum - 1;
        while (n >= 0) {
            int n2 = nArray[n];
            int n3 = n2 & 0xFE0000;
            int n4 = n2 & 0xFE00;
            int n5 = n2 & 0xFE;
            if (n3 != 0) {
                n3 -= 131072;
            }
            if (n4 != 0) {
                n4 -= 512;
            }
            if (n5 != 0) {
                n5 -= 2;
            }
            nArray[n] = n3 | n4 | n5;
            --n;
        }
    }

    final void drawImage(Picture picture, int n, int n2, int n3) {
        this.drawImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), 1, 16, 0);
    }

    final void drawImage(Picture picture, int n, int n2, int n3, int n4, int n5) {
        this.drawImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), n4, n5, 0);
    }

    final void drawImage(Picture picture, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), n4, n5, n6);
    }

    final void drawImageCenter(Picture picture, int n, int n2, int n3) {
        this.drawImageAlpha(picture.getPixel(n), n2 - picture.getWidth() / 2, n3 - picture.getHeight() / 2, picture.getWidth(), picture.getHeight(), 1, 16, 0);
    }

    final void drawImageCenter(Picture picture, int n, int n2, int n3, int n4, int n5) {
        this.drawImageAlpha(picture.getPixel(n), n2 - picture.getWidth() / 2, n3 - picture.getHeight() / 2, picture.getWidth(), picture.getHeight(), n4, n5, 0);
    }

    final void drawImageCenter(Picture picture, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawImageAlpha(picture.getPixel(n), n2 - picture.getWidth() / 2, n3 - picture.getHeight() / 2, picture.getWidth(), picture.getHeight(), n4, n5, n6);
    }

    final void drawRotImage(Picture picture, int n, int n2, int n3, int n4) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawImageAlpha(picture.getRotPixel(n, n4 / 5), n2 - picture.getRotWidth() / 2, n3 - picture.getRotHeight() / 2, picture.getRotWidth(), picture.getRotHeight(), 1, 16, 0);
    }

    final void drawRotImage(Picture picture, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawImageAlpha(picture.getRotPixel(n, n4 / 5), n2 - picture.getRotWidth() / 2, n3 - picture.getRotHeight() / 2, picture.getRotWidth(), picture.getRotHeight(), n5, n6, 0);
    }

    final void drawRotImage(Picture picture, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawImageAlpha(picture.getRotPixel(n, n4 / 5), n2 - picture.getRotWidth() / 2, n3 - picture.getRotHeight() / 2, picture.getRotWidth(), picture.getRotHeight(), n5, n6, n7);
    }

    final void drawScaledImage(Picture picture, int n, int n2, int n3, double d) {
        this.drawScaledImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), d, 1, 16, 0);
    }

    final void drawScaledImage(Picture picture, int n, int n2, int n3, double d, int n4, int n5) {
        this.drawScaledImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), d, n4, n5, 0);
    }

    final void drawScaledImage(Picture picture, int n, int n2, int n3, double d, int n4, int n5, int n6) {
        this.drawScaledImageAlpha(picture.getPixel(n), n2, n3, picture.getWidth(), picture.getHeight(), d, n4, n5, n6);
    }

    final void drawRotScaledImage(Picture picture, int n, int n2, int n3, int n4, double d) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawScaledImageAlpha(picture.getRotPixel(n, n4 / 5), n2, n3, picture.getRotWidth(), picture.getRotHeight(), d, 1, 16, 0);
    }

    final void drawRotScaledImage(Picture picture, int n, int n2, int n3, int n4, double d, int n5, int n6) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawScaledImageAlpha(picture.getRotPixel(n, n4 / 5), n2, n3, picture.getRotWidth(), picture.getRotHeight(), d, n5, n6, 0);
    }

    final void drawRotScaledImage(Picture picture, int n, int n2, int n3, int n4, double d, int n5, int n6, int n7) {
        if (n4 >= 360) {
            n4 %= 360;
        }
        while (n4 < 0) {
            n4 += 360;
        }
        this.drawScaledImageAlpha(picture.getRotPixel(n, n4 / 5), n2, n3, picture.getRotWidth(), picture.getRotHeight(), d, n5, n6, n7);
    }

    private final void drawImageAlpha(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n + n3 < 0 || n2 + n4 < 0 || n >= this.scrnWidth || n2 >= this.scrnHeight) {
            return;
        }
        if (n6 <= 0 || n6 > 16) {
            return;
        }
        int n8 = 0;
        int n9 = n3;
        int n10 = 0;
        int n11 = n4;
        if (n < 0) {
            n8 = -n;
        }
        if (n + n3 >= this.scrnWidth) {
            n9 = this.scrnWidth - n;
        }
        if (n2 < 0) {
            n10 = -n2;
        }
        if (n2 + n4 >= this.scrnHeight) {
            n11 = this.scrnHeight - n2;
        }
        if (n7 != 0) {
            n7 &= 0xFCFCFC;
        }
        int[] nArray2 = this.scrnBuff[this.bgNo];
        if (n7 == 0) {
            if (n5 == 0) {
                int n12 = n10;
                while (n12 < n11) {
                    int n13 = (n2 + n12) * this.scrnWidth + n;
                    int n14 = n12 * n3;
                    int n15 = n8;
                    while (n15 < n9) {
                        if (nArray[n14 + n15] != 0) {
                            nArray2[n13 + n15] = nArray[n14 + n15];
                        }
                        ++n15;
                    }
                    ++n12;
                }
            } else if (n5 == 1) {
                if (n6 == 16) {
                    int n16 = n10;
                    while (n16 < n11) {
                        int n17 = (n2 + n16) * this.scrnWidth + n;
                        int n18 = n16 * n3;
                        int n19 = n8;
                        while (n19 < n9) {
                            if (nArray[n18 + n19] != 0) {
                                nArray2[n17 + n19] = nArray[n18 + n19];
                            }
                            ++n19;
                        }
                        ++n16;
                    }
                } else if (n6 == 8) {
                    int n20 = n10;
                    while (n20 < n11) {
                        int n21 = (n2 + n20) * this.scrnWidth + n;
                        int n22 = n20 * n3;
                        int n23 = n8;
                        while (n23 < n9) {
                            if (nArray[n22 + n23] != 0) {
                                nArray2[n21 + n23] = Render.blend50(nArray2[n21 + n23], nArray[n22 + n23]);
                            }
                            ++n23;
                        }
                        ++n20;
                    }
                } else if (n6 == 12) {
                    int n24 = n10;
                    while (n24 < n11) {
                        int n25 = (n2 + n24) * this.scrnWidth + n;
                        int n26 = n24 * n3;
                        int n27 = n8;
                        while (n27 < n9) {
                            if (nArray[n26 + n27] != 0) {
                                nArray2[n25 + n27] = Render.blend75(nArray2[n25 + n27], nArray[n26 + n27]);
                            }
                            ++n27;
                        }
                        ++n24;
                    }
                } else if (n6 == 4) {
                    int n28 = n10;
                    while (n28 < n11) {
                        int n29 = (n2 + n28) * this.scrnWidth + n;
                        int n30 = n28 * n3;
                        int n31 = n8;
                        while (n31 < n9) {
                            if (nArray[n30 + n31] != 0) {
                                nArray2[n29 + n31] = Render.blend25(nArray2[n29 + n31], nArray[n30 + n31]);
                            }
                            ++n31;
                        }
                        ++n28;
                    }
                } else {
                    this.AlphaN = 16 - n6;
                    this.Alpha = n6;
                    int n32 = n10;
                    while (n32 < n11) {
                        int n33 = (n2 + n32) * this.scrnWidth + n;
                        int n34 = n32 * n3;
                        int n35 = n8;
                        while (n35 < n9) {
                            if (nArray[n34 + n35] != 0) {
                                nArray2[n33 + n35] = this.blendN(nArray2[n33 + n35], nArray[n34 + n35]);
                            }
                            ++n35;
                        }
                        ++n32;
                    }
                }
            } else if (n6 == 16) {
                int n36 = n10;
                while (n36 < n11) {
                    int n37 = (n2 + n36) * this.scrnWidth + n;
                    int n38 = n36 * n3;
                    int n39 = n8;
                    while (n39 < n9) {
                        if (nArray[n38 + n39] != 0) {
                            nArray2[n37 + n39] = Render.Add100(nArray2[n37 + n39], nArray[n38 + n39]);
                        }
                        ++n39;
                    }
                    ++n36;
                }
            } else if (n6 == 8) {
                int n40 = n10;
                while (n40 < n11) {
                    int n41 = (n2 + n40) * this.scrnWidth + n;
                    int n42 = n40 * n3;
                    int n43 = n8;
                    while (n43 < n9) {
                        if (nArray[n42 + n43] != 0) {
                            nArray2[n41 + n43] = Render.Add50(nArray2[n41 + n43], nArray[n42 + n43]);
                        }
                        ++n43;
                    }
                    ++n40;
                }
            } else {
                this.AlphaN = 16 - n6;
                this.Alpha = n6;
                int n44 = n10;
                while (n44 < n11) {
                    int n45 = (n2 + n44) * this.scrnWidth + n;
                    int n46 = n44 * n3;
                    int n47 = n8;
                    while (n47 < n9) {
                        if (nArray[n46 + n47] != 0) {
                            nArray2[n45 + n47] = this.AddN(nArray2[n45 + n47], nArray[n46 + n47]);
                        }
                        ++n47;
                    }
                    ++n44;
                }
            }
        } else if (n5 == 0) {
            int n48 = n10;
            while (n48 < n11) {
                int n49 = (n2 + n48) * this.scrnWidth + n;
                int n50 = n48 * n3;
                int n51 = n8;
                while (n51 < n9) {
                    if (nArray[n50 + n51] != 0) {
                        nArray2[n49 + n51] = n7;
                    }
                    ++n51;
                }
                ++n48;
            }
        } else if (n5 == 1) {
            if (n6 == 16) {
                int n52 = n10;
                while (n52 < n11) {
                    int n53 = (n2 + n52) * this.scrnWidth + n;
                    int n54 = n52 * n3;
                    int n55 = n8;
                    while (n55 < n9) {
                        if (nArray[n54 + n55] != 0) {
                            nArray2[n53 + n55] = n7;
                        }
                        ++n55;
                    }
                    ++n52;
                }
            } else if (n6 == 8) {
                int n56 = n10;
                while (n56 < n11) {
                    int n57 = (n2 + n56) * this.scrnWidth + n;
                    int n58 = n56 * n3;
                    int n59 = n8;
                    while (n59 < n9) {
                        if (nArray[n58 + n59] != 0) {
                            nArray2[n57 + n59] = Render.blend50(nArray2[n57 + n59], n7);
                        }
                        ++n59;
                    }
                    ++n56;
                }
            } else if (n6 == 12) {
                int n60 = n10;
                while (n60 < n11) {
                    int n61 = (n2 + n60) * this.scrnWidth + n;
                    int n62 = n60 * n3;
                    int n63 = n8;
                    while (n63 < n9) {
                        if (nArray[n62 + n63] != 0) {
                            nArray2[n61 + n63] = Render.blend75(nArray2[n61 + n63], n7);
                        }
                        ++n63;
                    }
                    ++n60;
                }
            } else if (n6 == 4) {
                int n64 = n10;
                while (n64 < n11) {
                    int n65 = (n2 + n64) * this.scrnWidth + n;
                    int n66 = n64 * n3;
                    int n67 = n8;
                    while (n67 < n9) {
                        if (nArray[n66 + n67] != 0) {
                            nArray2[n65 + n67] = Render.blend25(nArray2[n65 + n67], n7);
                        }
                        ++n67;
                    }
                    ++n64;
                }
            } else {
                this.AlphaN = 16 - n6;
                this.Alpha = n6;
                int n68 = n10;
                while (n68 < n11) {
                    int n69 = (n2 + n68) * this.scrnWidth + n;
                    int n70 = n68 * n3;
                    int n71 = n8;
                    while (n71 < n9) {
                        if (nArray[n70 + n71] != 0) {
                            nArray2[n69 + n71] = this.blendN(nArray2[n69 + n71], n7);
                        }
                        ++n71;
                    }
                    ++n68;
                }
            }
        } else if (n6 == 16) {
            int n72 = n10;
            while (n72 < n11) {
                int n73 = (n2 + n72) * this.scrnWidth + n;
                int n74 = n72 * n3;
                int n75 = n8;
                while (n75 < n9) {
                    if (nArray[n74 + n75] != 0) {
                        nArray2[n73 + n75] = Render.Add100(nArray2[n73 + n75], n7);
                    }
                    ++n75;
                }
                ++n72;
            }
        } else if (n6 == 8) {
            int n76 = n10;
            while (n76 < n11) {
                int n77 = (n2 + n76) * this.scrnWidth + n;
                int n78 = n76 * n3;
                int n79 = n8;
                while (n79 < n9) {
                    if (nArray[n78 + n79] != 0) {
                        nArray2[n77 + n79] = Render.Add50(nArray2[n77 + n79], n7);
                    }
                    ++n79;
                }
                ++n76;
            }
        } else {
            this.AlphaN = 16 - n6;
            this.Alpha = n6;
            int n80 = n10;
            while (n80 < n11) {
                int n81 = (n2 + n80) * this.scrnWidth + n;
                int n82 = n80 * n3;
                int n83 = n8;
                while (n83 < n9) {
                    if (nArray[n82 + n83] != 0) {
                        nArray2[n81 + n83] = this.AddN(nArray2[n81 + n83], n7);
                    }
                    ++n83;
                }
                ++n80;
            }
        }
    }

    private final void drawScaledImageAlpha(int[] nArray, int n, int n2, int n3, int n4, double d, int n5, int n6, int n7) {
        int n8 = (int)((double)n3 * d + 0.5);
        int n9 = (int)((double)n4 * d + 0.5);
        int n10 = n - n8 / 2;
        int n11 = n2 - n9 / 2;
        if (n10 + n8 < 0 || n11 + n9 < 0 || n10 >= this.scrnWidth || n11 >= this.scrnHeight) {
            return;
        }
        if (n6 <= 0 || n6 > 16) {
            return;
        }
        int n12 = 0;
        int n13 = n8;
        int n14 = 0;
        int n15 = n9;
        if (n10 < 0) {
            n12 = -n10;
        }
        if (n10 + n8 >= this.scrnWidth) {
            n13 = this.scrnWidth - n10;
        }
        if (n11 < 0) {
            n14 = -n11;
        }
        if (n11 + n9 >= this.scrnHeight) {
            n15 = this.scrnHeight - n11;
        }
        if (n7 != 0) {
            n7 &= 0xFCFCFC;
        }
        int[] nArray2 = this.scrnBuff[this.bgNo];
        if (n7 == 0) {
            if (n5 == 0) {
                int n16 = n14;
                while (n16 < n15) {
                    int n17 = (n11 + n16) * this.scrnWidth + n10;
                    int n18 = (int)((double)n16 / d) * n3;
                    int n19 = n12;
                    while (n19 < n13) {
                        int n20 = (int)((double)n19 / d);
                        if (nArray[n18 + n20] != 0) {
                            nArray2[n17 + n19] = nArray[n18 + n20];
                        }
                        ++n19;
                    }
                    ++n16;
                }
            } else if (n5 == 1) {
                if (n6 == 16) {
                    int n21 = n14;
                    while (n21 < n15) {
                        int n22 = (n11 + n21) * this.scrnWidth + n10;
                        int n23 = (int)((double)n21 / d) * n3;
                        int n24 = n12;
                        while (n24 < n13) {
                            int n25 = (int)((double)n24 / d);
                            if (nArray[n23 + n25] != 0) {
                                nArray2[n22 + n24] = nArray[n23 + n25];
                            }
                            ++n24;
                        }
                        ++n21;
                    }
                } else if (n6 == 8) {
                    int n26 = n14;
                    while (n26 < n15) {
                        int n27 = (n11 + n26) * this.scrnWidth + n10;
                        int n28 = (int)((double)n26 / d) * n3;
                        int n29 = n12;
                        while (n29 < n13) {
                            int n30 = (int)((double)n29 / d);
                            if (nArray[n28 + n30] != 0) {
                                nArray2[n27 + n29] = Render.blend50(nArray2[n27 + n29], nArray[n28 + n30]);
                            }
                            ++n29;
                        }
                        ++n26;
                    }
                } else if (n6 == 12) {
                    int n31 = n14;
                    while (n31 < n15) {
                        int n32 = (n11 + n31) * this.scrnWidth + n10;
                        int n33 = (int)((double)n31 / d) * n3;
                        int n34 = n12;
                        while (n34 < n13) {
                            int n35 = (int)((double)n34 / d);
                            if (nArray[n33 + n35] != 0) {
                                nArray2[n32 + n34] = Render.blend75(nArray2[n32 + n34], nArray[n33 + n35]);
                            }
                            ++n34;
                        }
                        ++n31;
                    }
                } else if (n6 == 4) {
                    int n36 = n14;
                    while (n36 < n15) {
                        int n37 = (n11 + n36) * this.scrnWidth + n10;
                        int n38 = (int)((double)n36 / d) * n3;
                        int n39 = n12;
                        while (n39 < n13) {
                            int n40 = (int)((double)n39 / d);
                            if (nArray[n38 + n40] != 0) {
                                nArray2[n37 + n39] = Render.blend25(nArray2[n37 + n39], nArray[n38 + n40]);
                            }
                            ++n39;
                        }
                        ++n36;
                    }
                } else {
                    this.AlphaN = 16 - n6;
                    this.Alpha = n6;
                    int n41 = n14;
                    while (n41 < n15) {
                        int n42 = (n11 + n41) * this.scrnWidth + n10;
                        int n43 = (int)((double)n41 / d) * n3;
                        int n44 = n12;
                        while (n44 < n13) {
                            int n45 = (int)((double)n44 / d);
                            if (nArray[n43 + n45] != 0) {
                                nArray2[n42 + n44] = this.blendN(nArray2[n42 + n44], nArray[n43 + n45]);
                            }
                            ++n44;
                        }
                        ++n41;
                    }
                }
            } else if (n6 == 16) {
                int n46 = n14;
                while (n46 < n15) {
                    int n47 = (n11 + n46) * this.scrnWidth + n10;
                    int n48 = (int)((double)n46 / d) * n3;
                    int n49 = n12;
                    while (n49 < n13) {
                        int n50 = (int)((double)n49 / d);
                        if (nArray[n48 + n50] != 0) {
                            nArray2[n47 + n49] = Render.Add100(nArray2[n47 + n49], nArray[n48 + n50]);
                        }
                        ++n49;
                    }
                    ++n46;
                }
            } else if (n6 == 8) {
                int n51 = n14;
                while (n51 < n15) {
                    int n52 = (n11 + n51) * this.scrnWidth + n10;
                    int n53 = (int)((double)n51 / d) * n3;
                    int n54 = n12;
                    while (n54 < n13) {
                        int n55 = (int)((double)n54 / d);
                        if (nArray[n53 + n55] != 0) {
                            nArray2[n52 + n54] = Render.Add50(nArray2[n52 + n54], nArray[n53 + n55]);
                        }
                        ++n54;
                    }
                    ++n51;
                }
            } else {
                this.AlphaN = 16 - n6;
                this.Alpha = n6;
                int n56 = n14;
                while (n56 < n15) {
                    int n57 = (n11 + n56) * this.scrnWidth + n10;
                    int n58 = (int)((double)n56 / d) * n3;
                    int n59 = n12;
                    while (n59 < n13) {
                        int n60 = (int)((double)n59 / d);
                        if (nArray[n58 + n60] != 0) {
                            nArray2[n57 + n59] = this.AddN(nArray2[n57 + n59], nArray[n58 + n60]);
                        }
                        ++n59;
                    }
                    ++n56;
                }
            }
        } else if (n5 == 0) {
            int n61 = n14;
            while (n61 < n15) {
                int n62 = (n11 + n61) * this.scrnWidth + n10;
                int n63 = (int)((double)n61 / d) * n3;
                int n64 = n12;
                while (n64 < n13) {
                    int n65 = (int)((double)n64 / d);
                    if (nArray[n63 + n65] != 0) {
                        nArray2[n62 + n64] = n7;
                    }
                    ++n64;
                }
                ++n61;
            }
        } else if (n5 == 1) {
            if (n6 == 16) {
                int n66 = n14;
                while (n66 < n15) {
                    int n67 = (n11 + n66) * this.scrnWidth + n10;
                    int n68 = (int)((double)n66 / d) * n3;
                    int n69 = n12;
                    while (n69 < n13) {
                        int n70 = (int)((double)n69 / d);
                        if (nArray[n68 + n70] != 0) {
                            nArray2[n67 + n69] = n7;
                        }
                        ++n69;
                    }
                    ++n66;
                }
            } else if (n6 == 8) {
                int n71 = n14;
                while (n71 < n15) {
                    int n72 = (n11 + n71) * this.scrnWidth + n10;
                    int n73 = (int)((double)n71 / d) * n3;
                    int n74 = n12;
                    while (n74 < n13) {
                        int n75 = (int)((double)n74 / d);
                        if (nArray[n73 + n75] != 0) {
                            nArray2[n72 + n74] = Render.blend50(nArray2[n72 + n74], n7);
                        }
                        ++n74;
                    }
                    ++n71;
                }
            } else if (n6 == 12) {
                int n76 = n14;
                while (n76 < n15) {
                    int n77 = (n11 + n76) * this.scrnWidth + n10;
                    int n78 = (int)((double)n76 / d) * n3;
                    int n79 = n12;
                    while (n79 < n13) {
                        int n80 = (int)((double)n79 / d);
                        if (nArray[n78 + n80] != 0) {
                            nArray2[n77 + n79] = Render.blend75(nArray2[n77 + n79], n7);
                        }
                        ++n79;
                    }
                    ++n76;
                }
            } else if (n6 == 4) {
                int n81 = n14;
                while (n81 < n15) {
                    int n82 = (n11 + n81) * this.scrnWidth + n10;
                    int n83 = (int)((double)n81 / d) * n3;
                    int n84 = n12;
                    while (n84 < n13) {
                        int n85 = (int)((double)n84 / d);
                        if (nArray[n83 + n85] != 0) {
                            nArray2[n82 + n84] = Render.blend25(nArray2[n82 + n84], n7);
                        }
                        ++n84;
                    }
                    ++n81;
                }
            } else {
                this.AlphaN = 16 - n6;
                this.Alpha = n6;
                int n86 = n14;
                while (n86 < n15) {
                    int n87 = (n11 + n86) * this.scrnWidth + n10;
                    int n88 = (int)((double)n86 / d) * n3;
                    int n89 = n12;
                    while (n89 < n13) {
                        int n90 = (int)((double)n89 / d);
                        if (nArray[n88 + n90] != 0) {
                            nArray2[n87 + n89] = this.blendN(nArray2[n87 + n89], n7);
                        }
                        ++n89;
                    }
                    ++n86;
                }
            }
        } else if (n6 == 16) {
            int n91 = n14;
            while (n91 < n15) {
                int n92 = (n11 + n91) * this.scrnWidth + n10;
                int n93 = (int)((double)n91 / d) * n3;
                int n94 = n12;
                while (n94 < n13) {
                    int n95 = (int)((double)n94 / d);
                    if (nArray[n93 + n95] != 0) {
                        nArray2[n92 + n94] = Render.Add100(nArray2[n92 + n94], n7);
                    }
                    ++n94;
                }
                ++n91;
            }
        } else if (n6 == 8) {
            int n96 = n14;
            while (n96 < n15) {
                int n97 = (n11 + n96) * this.scrnWidth + n10;
                int n98 = (int)((double)n96 / d) * n3;
                int n99 = n12;
                while (n99 < n13) {
                    int n100 = (int)((double)n99 / d);
                    if (nArray[n98 + n100] != 0) {
                        nArray2[n97 + n99] = Render.Add50(nArray2[n97 + n99], n7);
                    }
                    ++n99;
                }
                ++n96;
            }
        } else {
            this.AlphaN = 16 - n6;
            this.Alpha = n6;
            int n101 = n14;
            while (n101 < n15) {
                int n102 = (n11 + n101) * this.scrnWidth + n10;
                int n103 = (int)((double)n101 / d) * n3;
                int n104 = n12;
                while (n104 < n13) {
                    int n105 = (int)((double)n104 / d);
                    if (nArray[n103 + n105] != 0) {
                        nArray2[n102 + n104] = this.AddN(nArray2[n102 + n104], n7);
                    }
                    ++n104;
                }
                ++n101;
            }
        }
    }

    final void fillRect(int n, int n2, int n3, int n4, int n5) {
        this.fillRectAlpha(n, n2, n3, n4, n5, 1, 16);
    }

    final void fillRect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fillRectAlpha(n, n2, n3, n4, n5, n6, n7);
    }

    private final void fillRectAlpha(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n + n3 < 0 || n2 + n4 < 0 || n >= this.scrnWidth || n2 >= this.scrnHeight) {
            return;
        }
        if (n7 <= 0 || n7 > 16) {
            return;
        }
        int n8 = 0;
        int n9 = n3;
        int n10 = 0;
        int n11 = n4;
        if (n < 0) {
            n8 = -n;
        }
        if (n + n3 >= this.scrnWidth) {
            n9 = this.scrnWidth - n;
        }
        if (n2 < 0) {
            n10 = -n2;
        }
        if (n2 + n4 >= this.scrnHeight) {
            n11 = this.scrnHeight - n2;
        }
        if (n5 != 0) {
            n5 &= 0xFCFCFC;
        }
        int[] nArray = this.scrnBuff[this.bgNo];
        if (n6 == 1) {
            if (n7 == 16) {
                int n12 = n10;
                while (n12 < n11) {
                    int n13 = (n2 + n12) * this.scrnWidth + n;
                    int n14 = n12 * n3;
                    int n15 = n8;
                    while (n15 < n9) {
                        nArray[n13 + n15] = n5;
                        ++n15;
                    }
                    ++n12;
                }
            } else if (n7 == 8) {
                int n16 = n10;
                while (n16 < n11) {
                    int n17 = (n2 + n16) * this.scrnWidth + n;
                    int n18 = n16 * n3;
                    int n19 = n8;
                    while (n19 < n9) {
                        nArray[n17 + n19] = Render.blend50(nArray[n17 + n19], n5);
                        ++n19;
                    }
                    ++n16;
                }
            } else if (n7 == 12) {
                int n20 = n10;
                while (n20 < n11) {
                    int n21 = (n2 + n20) * this.scrnWidth + n;
                    int n22 = n20 * n3;
                    int n23 = n8;
                    while (n23 < n9) {
                        nArray[n21 + n23] = Render.blend75(nArray[n21 + n23], n5);
                        ++n23;
                    }
                    ++n20;
                }
            } else if (n7 == 4) {
                int n24 = n10;
                while (n24 < n11) {
                    int n25 = (n2 + n24) * this.scrnWidth + n;
                    int n26 = n24 * n3;
                    int n27 = n8;
                    while (n27 < n9) {
                        nArray[n25 + n27] = Render.blend25(nArray[n25 + n27], n5);
                        ++n27;
                    }
                    ++n24;
                }
            } else {
                this.AlphaN = 16 - n7;
                this.Alpha = n7;
                int n28 = n10;
                while (n28 < n11) {
                    int n29 = (n2 + n28) * this.scrnWidth + n;
                    int n30 = n28 * n3;
                    int n31 = n8;
                    while (n31 < n9) {
                        nArray[n29 + n31] = this.blendN(nArray[n29 + n31], n5);
                        ++n31;
                    }
                    ++n28;
                }
            }
        } else if (n7 == 16) {
            int n32 = n10;
            while (n32 < n11) {
                int n33 = (n2 + n32) * this.scrnWidth + n;
                int n34 = n32 * n3;
                int n35 = n8;
                while (n35 < n9) {
                    nArray[n33 + n35] = Render.Add100(nArray[n33 + n35], n5);
                    ++n35;
                }
                ++n32;
            }
        } else if (n7 == 8) {
            int n36 = n10;
            while (n36 < n11) {
                int n37 = (n2 + n36) * this.scrnWidth + n;
                int n38 = n36 * n3;
                int n39 = n8;
                while (n39 < n9) {
                    nArray[n37 + n39] = Render.Add50(nArray[n37 + n39], n5);
                    ++n39;
                }
                ++n36;
            }
        } else {
            this.AlphaN = 16 - n7;
            this.Alpha = n7;
            int n40 = n10;
            while (n40 < n11) {
                int n41 = (n2 + n40) * this.scrnWidth + n;
                int n42 = n40 * n3;
                int n43 = n8;
                while (n43 < n9) {
                    nArray[n41 + n43] = this.AddN(nArray[n41 + n43], n5);
                    ++n43;
                }
                ++n40;
            }
        }
    }

    final void drawRect(int n, int n2, int n3, int n4, int n5) {
        this.drawRectAlpha(n, n2, n3, n4, n5, 1, 16);
    }

    final void drawRect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRectAlpha(n, n2, n3, n4, n5, n6, n7);
    }

    private final void drawRectAlpha(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n + n3 < 0 || n2 + n4 < 0 || n >= this.scrnWidth || n2 >= this.scrnHeight) {
            return;
        }
        if (n7 <= 0 || n7 > 16) {
            return;
        }
        int n8 = 0;
        int n9 = n3;
        int n10 = 0;
        int n11 = n4;
        if (n < 0) {
            n8 = -n;
        }
        if (n + n3 >= this.scrnWidth) {
            n9 = this.scrnWidth - n;
        }
        if (n2 < 0) {
            n10 = -n2;
        }
        if (n2 + n4 >= this.scrnHeight) {
            n11 = this.scrnHeight - n2;
        }
        if (n5 != 0) {
            n5 &= 0xFCFCFC;
        }
        int[] nArray = this.scrnBuff[this.bgNo];
        if (n6 == 1) {
            if (n7 == 16) {
                int n12 = n10;
                while (n12 < n11) {
                    int n13 = (n2 + n12) * this.scrnWidth + n;
                    int n14 = n12 * n3;
                    if (n12 == n10 || n12 == n11 - 1) {
                        int n15 = n8;
                        while (n15 < n9) {
                            nArray[n13 + n15] = n5;
                            ++n15;
                        }
                    } else {
                        nArray[n13 + n8] = n5;
                        nArray[n13 + n9 - 1] = n5;
                    }
                    ++n12;
                }
            } else if (n7 == 8) {
                int n16 = n10;
                while (n16 < n11) {
                    int n17 = (n2 + n16) * this.scrnWidth + n;
                    int n18 = n16 * n3;
                    if (n16 == n10 || n16 == n11 - 1) {
                        int n19 = n8;
                        while (n19 < n9) {
                            nArray[n17 + n19] = Render.blend50(nArray[n17 + n19], n5);
                            ++n19;
                        }
                    } else {
                        nArray[n17 + n8] = Render.blend50(nArray[n17 + n8], n5);
                        nArray[n17 + n9 - 1] = Render.blend50(nArray[n17 + n9 - 1], n5);
                    }
                    ++n16;
                }
            } else if (n7 == 12) {
                int n20 = n10;
                while (n20 < n11) {
                    int n21 = (n2 + n20) * this.scrnWidth + n;
                    int n22 = n20 * n3;
                    if (n20 == n10 || n20 == n11 - 1) {
                        int n23 = n8;
                        while (n23 < n9) {
                            nArray[n21 + n23] = Render.blend75(nArray[n21 + n23], n5);
                            ++n23;
                        }
                    } else {
                        nArray[n21 + n8] = Render.blend75(nArray[n21 + n8], n5);
                        nArray[n21 + n9 - 1] = Render.blend75(nArray[n21 + n9 - 1], n5);
                    }
                    ++n20;
                }
            } else if (n7 == 4) {
                int n24 = n10;
                while (n24 < n11) {
                    int n25 = (n2 + n24) * this.scrnWidth + n;
                    int n26 = n24 * n3;
                    if (n24 == n10 || n24 == n11 - 1) {
                        int n27 = n8;
                        while (n27 < n9) {
                            nArray[n25 + n27] = Render.blend25(nArray[n25 + n27], n5);
                            ++n27;
                        }
                    } else {
                        nArray[n25 + n8] = Render.blend25(nArray[n25 + n8], n5);
                        nArray[n25 + n9 - 1] = Render.blend25(nArray[n25 + n9 - 1], n5);
                    }
                    ++n24;
                }
            } else {
                this.AlphaN = 16 - n7;
                this.Alpha = n7;
                int n28 = n10;
                while (n28 < n11) {
                    int n29 = (n2 + n28) * this.scrnWidth + n;
                    int n30 = n28 * n3;
                    if (n28 == n10 || n28 == n11 - 1) {
                        int n31 = n8;
                        while (n31 < n9) {
                            nArray[n29 + n31] = this.blendN(nArray[n29 + n31], n5);
                            ++n31;
                        }
                    } else {
                        nArray[n29 + n8] = this.blendN(nArray[n29 + n8], n5);
                        nArray[n29 + n9 - 1] = this.blendN(nArray[n29 + n9 - 1], n5);
                    }
                    ++n28;
                }
            }
        } else if (n7 == 16) {
            int n32 = n10;
            while (n32 < n11) {
                int n33 = (n2 + n32) * this.scrnWidth + n;
                int n34 = n32 * n3;
                if (n32 == n10 || n32 == n11 - 1) {
                    int n35 = n8;
                    while (n35 < n9) {
                        nArray[n33 + n35] = Render.Add100(nArray[n33 + n35], n5);
                        ++n35;
                    }
                } else {
                    nArray[n33 + n8] = Render.Add100(nArray[n33 + n8], n5);
                    nArray[n33 + n9 - 1] = Render.Add100(nArray[n33 + n9 - 1], n5);
                }
                ++n32;
            }
        } else if (n7 == 8) {
            int n36 = n10;
            while (n36 < n11) {
                int n37 = (n2 + n36) * this.scrnWidth + n;
                int n38 = n36 * n3;
                if (n36 == n10 || n36 == n11 - 1) {
                    int n39 = n8;
                    while (n39 < n9) {
                        nArray[n37 + n39] = Render.Add50(nArray[n37 + n39], n5);
                        ++n39;
                    }
                } else {
                    nArray[n37 + n8] = Render.Add50(nArray[n37 + n8], n5);
                    nArray[n37 + n9 - 1] = Render.Add50(nArray[n37 + n9 - 1], n5);
                }
                ++n36;
            }
        } else {
            this.AlphaN = 16 - n7;
            this.Alpha = n7;
            int n40 = n10;
            while (n40 < n11) {
                int n41 = (n2 + n40) * this.scrnWidth + n;
                int n42 = n40 * n3;
                if (n40 == n10 || n40 == n11 - 1) {
                    int n43 = n8;
                    while (n43 < n9) {
                        nArray[n41 + n43] = this.AddN(nArray[n41 + n43], n5);
                        ++n43;
                    }
                } else {
                    nArray[n41 + n8] = this.AddN(nArray[n41 + n8], n5);
                    nArray[n41 + n9 - 1] = this.AddN(nArray[n41 + n9 - 1], n5);
                }
                ++n40;
            }
        }
    }

    static final int blend50(int n, int n2) {
        return ((n & 0xFEFEFE) >> 1) + (n2 >> 1);
    }

    static final int blend75(int n, int n2) {
        return ((n & 0xFCFCFC) >> 2) + n2 - (n2 >> 2);
    }

    static final int blend25(int n, int n2) {
        return n - ((n & 0xFCFCFC) >> 2) + (n2 >> 2);
    }

    final int blendN(int n, int n2) {
        return ((n & 0xFF00FF) * this.AlphaN + (n2 & 0xFF00FF) * this.Alpha & 0xFF00FF0 | (n & 0xFF00) * this.AlphaN + (n2 & 0xFF00) * this.Alpha & 0xFF000) >> 4;
    }

    static final int Add100(int n, int n2) {
        int n3 = (n & 0xFF0000) + (n2 & 0xFF0000);
        int n4 = (n & 0xFF00) + (n2 & 0xFF00);
        int n5 = (n & 0xFF) + (n2 & 0xFF);
        if (n3 > 0xFF0000) {
            n3 = 0xFF0000;
        }
        if (n4 > 65280) {
            n4 = 65280;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return n3 | n4 | n5;
    }

    static final int Add50(int n, int n2) {
        int n3 = (n & 0xFF0000) + ((n2 & 0xFF0000) >> 1 & 0xFF0000);
        int n4 = (n & 0xFF00) + ((n2 & 0xFF00) >> 1 & 0xFF00);
        int n5 = (n & 0xFF) + ((n2 & 0xFF) >> 1);
        if (n3 > 0xFF0000) {
            n3 = 0xFF0000;
        }
        if (n4 > 65280) {
            n4 = 65280;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return n3 | n4 | n5;
    }

    final int AddN(int n, int n2) {
        int n3 = (n & 0xFF0000) + ((n2 & 0xFF0000) * this.Alpha >> 4 & 0xFF0000);
        int n4 = (n & 0xFF00) + ((n2 & 0xFF00) * this.Alpha >> 4 & 0xFF00);
        int n5 = (n & 0xFF) + ((n2 & 0xFF) * this.Alpha >> 4);
        if (n3 > 0xFF0000) {
            n3 = 0xFF0000;
        }
        if (n4 > 65280) {
            n4 = 65280;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return n3 | n4 | n5;
    }

    final void drawPixels(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            this.scrnBuff[this.bgNo][nArray2[n2] * this.scrnWidth + nArray[n2]] = nArray3[n2];
            --n2;
        }
    }

    final void rasterScroll(int n, int n2) {
        int n3 = n2 < 0 ? this.scrnWidth + n2 : n2;
        if (n3 < 0 || n3 >= this.scrnWidth) {
            return;
        }
        int[] nArray = this.scrnBuff[this.bgNo];
        int n4 = n * this.scrnWidth;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            this.lineBuff[n5] = nArray[n4 + n5];
            --n5;
        }
        n5 = this.scrnWidth - n3 - 1;
        while (n5 >= 0) {
            nArray[n4 + n5] = nArray[n4 + n3 + n5];
            --n5;
        }
        n5 = n3 - 1;
        while (n5 >= 0) {
            nArray[n4 + this.scrnWidth - n3 + n5] = this.lineBuff[n5];
            --n5;
        }
    }

    final void drawString(Picture picture, int n, int n2, String string) {
        int n3 = picture.getWidth();
        int n4 = picture.getHeight();
        int n5 = string.length() - 1;
        while (n5 >= 0) {
            char c = string.charAt(n5);
            this.drawImageAlpha(picture.getPixel(c), n + n5 * n3, n2, n3, n4, 1, 16, 0);
            --n5;
        }
    }

    final void drawString(Picture picture, int n, int n2, String string, int n3, int n4) {
        int n5 = picture.getWidth();
        int n6 = picture.getHeight();
        int n7 = string.length() - 1;
        while (n7 >= 0) {
            char c = string.charAt(n7);
            this.drawImageAlpha(picture.getPixel(c), n + n7 * n5, n2, n5, n6, n3, n4, 0);
            --n7;
        }
    }

    final void drawString(Picture picture, int n, int n2, String string, int n3, int n4, int n5) {
        int n6 = picture.getWidth();
        int n7 = picture.getHeight();
        int n8 = string.length() - 1;
        while (n8 >= 0) {
            char c = string.charAt(n8);
            this.drawImageAlpha(picture.getPixel(c), n + n8 * n6, n2, n6, n7, n3, n4, n5);
            --n8;
        }
    }

    final void drawScaledString(Picture picture, int n, int n2, String string, double d, int n3, int n4) {
        int n5 = picture.getWidth();
        double d2 = (int)((double)(string.length() * n5) * d);
        int n6 = (int)((double)picture.getHeight() * d);
        int n7 = string.length() - 1;
        while (n7 >= 0) {
            char c = string.charAt(n7);
            this.drawScaledImage(picture, c, (int)((double)n - d2 / 2.0 + ((double)n7 + 0.5) * (double)n5 * d), n2 - n6 / 2, d, n3, n4);
            --n7;
        }
    }

    final void drawStringCenter(Picture picture, int n, int n2, String string, int n3, int n4) {
        int n5 = picture.getWidth();
        int n6 = picture.getHeight();
        int n7 = string.length() * n5;
        int n8 = string.length() - 1;
        while (n8 >= 0) {
            char c = string.charAt(n8);
            this.drawImageAlpha(picture.getPixel(c), n + n8 * n5 - n7 / 2, n2 - n6 / 2, n5, n6, n3, n4, 0);
            --n8;
        }
    }

    final void drawStringCenter(Picture picture, int n, int n2, String string, int n3, int n4, int n5) {
        int n6 = picture.getWidth();
        int n7 = picture.getHeight();
        int n8 = string.length() * n6;
        int n9 = string.length() - 1;
        while (n9 >= 0) {
            char c = string.charAt(n9);
            this.drawImageAlpha(picture.getPixel(c), n - n8 / 2 + n9 * n6, n2 - n7 / 2, n6, n7, n3, n4, n5);
            --n9;
        }
    }

    final void drawLineX(int n, int n2, int n3, int n4, int n5) {
        if (n3 < 0 || n3 >= this.scrnHeight) {
            return;
        }
        if (n > n2) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.scrnWidth) {
            n2 = this.scrnWidth;
        }
        int[] nArray = this.scrnBuff[this.bgNo];
        if (n5 == 16) {
            int n6 = n;
            while (n6 < n2) {
                nArray[n3 * this.scrnWidth + n6] = n4;
                ++n6;
            }
        } else if (n5 == 8) {
            int n7 = n;
            while (n7 < n2) {
                nArray[n3 * this.scrnWidth + n7] = Render.blend50(nArray[n3 * this.scrnWidth + n7], n4);
                ++n7;
            }
        } else if (n5 == 12) {
            int n8 = n;
            while (n8 < n2) {
                nArray[n3 * this.scrnWidth + n8] = Render.blend75(nArray[n3 * this.scrnWidth + n8], n4);
                ++n8;
            }
        } else if (n5 == 4) {
            int n9 = n;
            while (n9 < n2) {
                nArray[n3 * this.scrnWidth + n9] = Render.blend25(nArray[n3 * this.scrnWidth + n9], n4);
                ++n9;
            }
        } else {
            this.AlphaN = 16 - n5;
            this.Alpha = n5;
            int n10 = n;
            while (n10 < n2) {
                nArray[n3 * this.scrnWidth + n10] = this.blendN(nArray[n3 * this.scrnWidth + n10], n4);
                ++n10;
            }
        }
    }

    final void drawLineY(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n >= this.scrnWidth) {
            return;
        }
        if (n2 > n3) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= this.scrnHeight) {
            n3 = this.scrnHeight;
        }
        int[] nArray = this.scrnBuff[this.bgNo];
        if (n5 == 16) {
            int n6 = n2;
            while (n6 < n3) {
                nArray[n6 * this.scrnWidth + n] = n4;
                ++n6;
            }
        } else if (n5 == 8) {
            int n7 = n2;
            while (n7 < n3) {
                nArray[n7 * this.scrnWidth + n] = Render.blend50(nArray[n7 * this.scrnWidth + n], n4);
                ++n7;
            }
        } else if (n5 == 12) {
            int n8 = n2;
            while (n8 < n3) {
                nArray[n8 * this.scrnWidth + n] = Render.blend75(nArray[n8 * this.scrnWidth + n], n4);
                ++n8;
            }
        } else if (n5 == 4) {
            int n9 = n2;
            while (n9 < n3) {
                nArray[n9 * this.scrnWidth + n] = Render.blend25(nArray[n9 * this.scrnWidth + n], n4);
                ++n9;
            }
        } else {
            this.AlphaN = 16 - n5;
            this.Alpha = n5;
            int n10 = n2;
            while (n10 < n3) {
                nArray[n10 * this.scrnWidth + n] = this.blendN(nArray[n10 * this.scrnWidth + n], n4);
                ++n10;
            }
        }
    }

    final void drawLine16(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        if (n < 0) {
            n7 |= 1;
        }
        if (n >= this.scrnWidth) {
            n7 |= 2;
        }
        if (n2 < 0) {
            n7 |= 4;
        }
        if (n2 >= this.scrnHeight) {
            n7 |= 8;
        }
        if (n3 < 0) {
            n8 |= 1;
        }
        if (n3 >= this.scrnWidth) {
            n8 |= 2;
        }
        if (n4 < 0) {
            n8 |= 4;
        }
        if (n4 >= this.scrnHeight) {
            n8 |= 8;
        }
        if ((n7 & n8) != 0) {
            return;
        }
        this.drawline(n << 16, n2 << 16, n3 << 16, n4 << 16, n5, n6);
    }

    private final void drawline(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs((n3 >> 16) - (n >> 16));
        int n8 = Math.abs((n4 >> 16) - (n2 >> 16));
        int[] nArray = this.scrnBuff[this.bgNo];
        if (n7 < n8) {
            if (n8 == 0) {
                ++n8;
            }
            int n9 = (n3 - n) / n8;
            int n10 = n4 - n2 >> 31 | 1;
            n2 >>= 16;
            int n11 = n8 - 1;
            while (n11 >= 0) {
                int n12 = n >> 16;
                if (n12 >= 0 && n12 < this.scrnWidth - 1 && n2 >= 0 && n2 < this.scrnHeight - 1) {
                    int n13 = n2 * this.scrnWidth + n12;
                    int n14 = n >> 8 & 0xFF;
                    nArray[n13] = this.calcPixelColor(nArray[n13], n5, n14, n6);
                    nArray[n13 + 1] = this.calcPixelColor(nArray[n13 + 1], n5, 255 - n14, n6);
                }
                n += n9;
                n2 += n10;
                --n11;
            }
        } else {
            if (n7 == 0) {
                ++n7;
            }
            int n15 = (n4 - n2) / n7;
            int n16 = n3 - n >> 31 | 1;
            n >>= 16;
            int n17 = n7 - 1;
            while (n17 >= 0) {
                int n18 = n2 >> 16;
                if (n18 >= 0 && n18 < this.scrnHeight - 1 && n >= 0 && n < this.scrnWidth - 1) {
                    int n19 = n18 * this.scrnWidth + n;
                    int n20 = n2 >> 8 & 0xFF;
                    nArray[n19] = this.calcPixelColor(nArray[n19], n5, n20, n6);
                    nArray[n19 + this.scrnWidth] = this.calcPixelColor(nArray[n19 + this.scrnWidth], n5, 255 - n20, n6);
                }
                n += n16;
                n2 += n15;
                --n17;
            }
        }
    }

    private final int calcPixelColor(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 255 - n3;
        if (n4 == 2) {
            int n7 = (n & 0xFF0000) + (n2 & 0xFF0000);
            int n8 = (n & 0xFF00) + (n2 & 0xFF00);
            int n9 = (n & 0xFF) + (n2 & 0xFF);
            if (n7 > 0xFF0000) {
                n7 = 0xFF0000;
            }
            if (n8 > 65280) {
                n8 = 65280;
            }
            if (n9 > 255) {
                n9 = 255;
            }
            n5 = n7 | n8 | n9;
        } else {
            n5 = (n & 0xFF0000) * n3 + (n2 & 0xFF0000) * n6 & 0xFF000000;
            n5 |= (n & 0xFF00) * n3 + (n2 & 0xFF00) * n6 & 0xFF0000;
            n5 |= (n & 0xFF) * n3 + (n2 & 0xFF) * n6;
            n5 >>= 8;
        }
        return n5;
    }

    public final void startProduction(ImageConsumer imageConsumer) {
        this.colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
        this.imageConsumer = imageConsumer;
        switch (this.renderMode) {
            case 1: {
                this.imageConsumer.setDimensions(this.scrnWidth, this.scrnHeight);
                break;
            }
            case 2: {
                this.imageConsumer.setDimensions(this.scrnWidth * 2, this.scrnHeight * 2);
                break;
            }
            case 3: {
                this.imageConsumer.setDimensions(this.scrnWidth * 2, this.scrnHeight * 2);
            }
        }
        this.imageConsumer.setColorModel(this.colorModel);
        this.imageConsumer.setHints(30);
        this.isStart = true;
    }

    public final void addConsumer(ImageConsumer imageConsumer) {
        System.out.println("!addConsumer");
    }

    public final boolean isConsumer(ImageConsumer imageConsumer) {
        System.out.println("!isConsumer");
        return false;
    }

    public final void removeConsumer(ImageConsumer imageConsumer) {
        System.out.println("!removeConsumer");
    }

    public final void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        System.out.println("!requestTopDownLeftRightResend");
    }

    public final void paint(Graphics graphics) {
        this.drawScreen();
    }

    public final void repaint() {
        this.drawScreen();
    }

    public final void update(Graphics graphics) {
        this.drawScreen();
    }

    private final void drawScreen() {
        this.updateScreen();
    }
}

