/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;

final class Picture {
    static boolean err;
    private static int loadedNum;
    private static Applet baseApplet;
    private static MediaTracker mt;
    private static Picture[] pictureObject;
    static final int MAX = 16;
    private static int pictureCounter;
    private String pictureName;
    private int[][] pixelArray;
    private int[][][] pixelRotArray;
    private int rotWidth;
    private int rotHeight;
    static final int ROT_NUM = 72;
    static final int DEGREE = 360;
    static final int ROT_PREC = 5;
    static final int OVR_SMP = 2;
    private int cellWidth;
    private int cellHeight;

    final String getName() {
        return this.pictureName;
    }

    final int getNum() {
        return this.pixelArray.length;
    }

    final int[] getPixel(int n) {
        return this.pixelArray[n];
    }

    final int getWidth() {
        return this.cellWidth;
    }

    final int getHeight() {
        return this.cellHeight;
    }

    final int[] getRotPixel(int n, int n2) {
        return this.pixelRotArray[n][n2];
    }

    final int getRotWidth() {
        return this.rotWidth;
    }

    final int getRotHeight() {
        return this.rotHeight;
    }

    static void init(Applet applet) {
        System.out.println("Picture.init");
        baseApplet = applet;
        mt = new MediaTracker(applet);
        pictureObject = new Picture[16];
        pictureCounter = 0;
        loadedNum = 1;
        err = false;
    }

    static void release() {
        System.out.println("Picture.release");
        pictureObject = null;
        System.gc();
    }

    static int create(String string, int n, int n2, int n3, int n4, int n5) {
        try {
            int n6 = 0;
            while (n6 < 16 && pictureObject[n6] != null && Picture.pictureObject[n6].pictureName != null) {
                if (Picture.pictureObject[n6].pictureName.equals(string)) {
                    return n6;
                }
                ++n6;
            }
            System.out.println(string);
            Image image = baseApplet.getImage(baseApplet.getCodeBase(), string);
            mt.addImage(image, 0);
            mt.waitForID(0);
            int n7 = image.getWidth(null);
            int n8 = image.getHeight(null);
            if (n7 <= 0 || n8 <= 0) {
                throw new Exception("Cannot read " + string);
            }
            int[] nArray = new int[n7 * n8];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n7, n8, nArray, 0, n7);
            pixelGrabber.grabPixels();
            pixelGrabber = null;
            image.flush();
            System.gc();
            Picture picture = new Picture(string);
            picture.setPictureSource(nArray, n7, n8, n, n2, n3, n4, n5);
            int n9 = pictureCounter++;
            Picture.pictureObject[n9] = picture;
            return n9;
        }
        catch (Exception exception) {
            System.out.println(string + "Read Error");
            exception.printStackTrace();
            err = true;
            int n10 = -1;
            return n10;
        }
    }

    static Picture get(int n) {
        if (pictureObject == null) {
            return null;
        }
        return pictureObject[n % 16];
    }

    public Picture(String string) {
        this.pictureName = string;
    }

    void createRotImagePlain(int n) {
        this.pixelRotArray[n] = new int[72][];
        int n2 = 0;
        while (n2 < 72) {
            int n3;
            int[] nArray = new int[this.rotWidth * this.rotHeight];
            int n4 = 0;
            while (n4 < this.rotHeight) {
                int n5 = 0;
                while (n5 < this.rotWidth) {
                    nArray[n4 * this.rotWidth + n5] = -1;
                    ++n5;
                }
                ++n4;
            }
            double d = (double)(n2 * 5) * Math.PI / 180.0;
            int n6 = 0;
            while (n6 < this.cellHeight) {
                n3 = 0;
                while (n3 < this.cellWidth) {
                    double d2 = (double)n3 - ((double)(this.cellWidth / 2) - 0.5);
                    double d3 = (double)n6 - ((double)(this.cellHeight / 2) - 0.5);
                    double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
                    double d5 = d2 * Math.sin(d) + d3 * Math.cos(d);
                    int n7 = (int)(d4 + (double)(this.rotWidth / 2));
                    int n8 = (int)(d5 + (double)(this.rotHeight / 2));
                    nArray[n8 * this.rotWidth + n7] = this.pixelArray[n][n6 * this.cellWidth + n3];
                    ++n3;
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < this.rotHeight) {
                int n9 = 1;
                while (n9 < this.rotWidth - 1) {
                    if (nArray[n3 * this.rotWidth + n9] == -1 && nArray[n3 * this.rotWidth + n9 - 1] > 0 && nArray[n3 * this.rotWidth + n9 + 1] > 0) {
                        nArray[n3 * this.rotWidth + n9] = nArray[n3 * this.rotWidth + n9 - 1];
                    }
                    ++n9;
                }
                ++n3;
            }
            int n10 = 0;
            while (n10 < this.rotHeight) {
                int n11 = 0;
                while (n11 < this.rotWidth) {
                    if (nArray[n10 * this.rotWidth + n11] == -1) {
                        nArray[n10 * this.rotWidth + n11] = 0;
                    }
                    ++n11;
                }
                ++n10;
            }
            this.pixelRotArray[n][n2] = nArray;
            ++n2;
        }
    }

    void createRotImage(int n) {
        this.pixelRotArray[n] = new int[72][];
        int n2 = this.cellWidth * 2;
        int n3 = this.cellHeight * 2;
        int n4 = this.rotWidth * 2;
        int n5 = this.rotHeight * 2;
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[n4 * n5];
        int n6 = 0;
        while (n6 < 72) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int[] nArray3 = new int[this.rotWidth * this.rotHeight];
            int n12 = 0;
            while (n12 < this.cellHeight) {
                n11 = 0;
                while (n11 < this.cellWidth) {
                    nArray[n12 * 2 * n3 + n11 * 2] = this.pixelArray[n][n12 * this.cellWidth + n11];
                    nArray[n12 * 2 * n3 + n11 * 2 + 1] = this.pixelArray[n][n12 * this.cellWidth + n11];
                    nArray[(n12 * 2 + 1) * n3 + n11 * 2] = this.pixelArray[n][n12 * this.cellWidth + n11];
                    nArray[(n12 * 2 + 1) * n3 + n11 * 2 + 1] = this.pixelArray[n][n12 * this.cellWidth + n11];
                    ++n11;
                }
                ++n12;
            }
            n11 = 0;
            while (n11 < n5) {
                int n13 = 0;
                while (n13 < n4) {
                    nArray2[n11 * n4 + n13] = -1;
                    ++n13;
                }
                ++n11;
            }
            double d = (double)(n6 * 5) * Math.PI / 180.0;
            int n14 = 0;
            while (n14 < n3) {
                n10 = 0;
                while (n10 < n2) {
                    double d2 = (double)n10 - ((double)(n2 / 2) - 0.5);
                    double d3 = (double)n14 - ((double)(n3 / 2) - 0.5);
                    double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
                    double d5 = d2 * Math.sin(d) + d3 * Math.cos(d);
                    n9 = (int)(d4 + (double)(n4 / 2));
                    n8 = (int)(d5 + (double)(n5 / 2));
                    nArray2[n8 * n4 + n9] = nArray[n14 * n2 + n10];
                    ++n10;
                }
                ++n14;
            }
            n10 = 0;
            while (n10 < n5) {
                int n15 = 1;
                while (n15 < n4 - 1) {
                    if (nArray2[n10 * n4 + n15] == -1 && nArray2[n10 * n4 + n15 - 1] > 0 && nArray2[n10 * n4 + n15 + 1] > 0) {
                        nArray2[n10 * n4 + n15] = nArray2[n10 * n4 + n15 - 1];
                    }
                    ++n15;
                }
                ++n10;
            }
            int n16 = 0;
            while (n16 < n5) {
                n7 = 0;
                while (n7 < n4) {
                    if (nArray2[n16 * n4 + n7] == -1) {
                        nArray2[n16 * n4 + n7] = 0;
                    }
                    ++n7;
                }
                ++n16;
            }
            n7 = 0;
            while (n7 < this.rotHeight) {
                int n17 = 0;
                while (n17 < this.rotWidth) {
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = nArray2[n7 * 2 * n4 + n17 * 2];
                    n9 = nArray2[n7 * 2 * n4 + n17 * 2 + 1];
                    n8 = nArray2[(n7 * 2 + 1) * n4 + n17 * 2];
                    int n23 = nArray2[(n7 * 2 + 1) * n4 + n17 * 2 + 1];
                    if (n22 != 0) {
                        ++n18;
                        n19 += (n22 & 0xFF0000) >> 16;
                        n20 += (n22 & 0xFF00) >> 8;
                        n21 += n22 & 0xFF;
                    }
                    if (n9 != 0) {
                        ++n18;
                        n19 += (n9 & 0xFF0000) >> 16;
                        n20 += (n9 & 0xFF00) >> 8;
                        n21 += n9 & 0xFF;
                    }
                    if (n8 != 0) {
                        ++n18;
                        n19 += (n8 & 0xFF0000) >> 16;
                        n20 += (n8 & 0xFF00) >> 8;
                        n21 += n8 & 0xFF;
                    }
                    if (n23 != 0) {
                        ++n18;
                        n19 += (n23 & 0xFF0000) >> 16;
                        n20 += (n23 & 0xFF00) >> 8;
                        n21 += n23 & 0xFF;
                    }
                    if (n18 != 0) {
                        int n24 = n19 / n18;
                        int n25 = n20 / n18;
                        int n26 = n21 / n18;
                        nArray3[n7 * this.rotWidth + n17] = (n18 << 24) + (n24 << 16) + (n25 << 8) + n26;
                    } else {
                        nArray3[n7 * this.rotWidth + n17] = 0;
                    }
                    ++n17;
                }
                ++n7;
            }
            this.pixelRotArray[n][n6] = nArray3;
            ++n6;
        }
        nArray = null;
        nArray2 = null;
    }

    void setPictureSource(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cellWidth = n3 * n7;
        this.cellHeight = n4 * n7;
        this.pixelArray = new int[n5 * n6][this.cellWidth * this.cellHeight];
        if (this.cellWidth >= this.cellHeight) {
            this.rotWidth = (int)((double)this.cellWidth * 1.5);
            this.rotHeight = (int)((double)this.cellWidth * 1.5);
        } else {
            this.rotWidth = (int)((double)this.cellHeight * 1.5);
            this.rotHeight = (int)((double)this.cellHeight * 1.5);
        }
        this.pixelRotArray = new int[n5 * n6][][];
        int n8 = 0;
        while (n8 < n6) {
            int n9 = 0;
            while (n9 < n5) {
                int[] nArray2 = new int[this.cellWidth * this.cellHeight];
                this.splitPixel(nArray, nArray2, n3 * n9, n4 * n8, n3, n4, n, n7);
                this.pixelArray[n9 + n8 * n5] = nArray2;
                ++loadedNum;
                ++n9;
            }
            ++n8;
        }
    }

    private void splitPixel(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (n6 == 1) {
            int n8 = 0;
            while (n8 < n4) {
                int n9 = (n2 + n8) * n5 + n;
                int n10 = 0;
                while (n10 < n3) {
                    nArray2[n7] = nArray[n9] & 0xFCFCFC;
                    ++n7;
                    ++n9;
                    ++n10;
                }
                ++n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n4) {
                int n12 = 0;
                while (n12 < n6) {
                    int n13 = (n2 + n11) * n5 + n;
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = 0;
                        while (n15 < n6) {
                            nArray2[n7] = nArray[n13] & 0xFCFCFC;
                            ++n7;
                            ++n15;
                        }
                        ++n13;
                        ++n14;
                    }
                    ++n12;
                }
                ++n11;
            }
        }
    }

    public String toString() {
        return this.pictureName + ",n=" + this.pixelArray.length + ",w=" + this.cellWidth + ",h=" + this.cellHeight;
    }

    static final void debugOut() {
        if (pictureObject == null) {
            return;
        }
        System.out.println("Picture.debugOut");
        int n = 0;
        while (n < pictureObject.length) {
            if (pictureObject[n] != null) {
                System.out.println(pictureObject[n]);
            }
            ++n;
        }
    }
}

