<?php

define('SM_PATH', '../../');
require_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/addressbook.php');

/*
 * Main Code
 * 
 */

global $username;

$abook = addressbook_init(true,true);
$rows = $abook->list_addr();
mb_convert_variables( "SJIS", "auto", $rows) ;


header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

header('Cache-control: private', false);
header('Content-Type: application/CSV');
header('Content-Disposition: attachment; filename="' . $username . '-addresses.csv"');

foreach($rows as $row) {
//	echo $row[0].','.$row[2].','.$row[3].','.$row[4].','.$row[5].','."\n" ;
//	echo implode(',', array_slice($row, 0, -2)) . "\n";

	echo implode(',', array_slice($row, 0, 1))  . "," ;
	echo implode(',', array_slice($row, 2, -2)) . "\r\n";


}

?>
