<?php
/*******************************************************************************

    Author ......... Kiyoshi Sawada
    Contact ........ sawada_k@na.rim.or.jp
    Home Site ...... http://www.na.rim.or.jp/~sawada_k/php/squirrelmail/index.html
    Program ........ NotesDB
    Version ........ 0.71-jp
    Purpose ........ PostgreSQL Storing Notes

*******************************************************************************/

// Max number of notes a user can have
$n->maxnotescount = 15;

// Max size of a note (to disable, just set to 0)
$n->maxnotesize = 5000;

// Max size of all notes (to disable, just set to 0)
$n->maxnotessize = 60000;

// Edit Title ROWS ( default = 30 )
$n->edit_title_rows = 50;

// Edit Title MAXLENGTH ( default = 30 )
$n->edit_title_maxlength = 100;

// Edit TEXTAREA ROWS ( default = 30 )
$n->edit_textarea_rows = 25;

// Edit TEXTAREA COLS ( default = 80 )
$n->edit_textarea_cols = 72;

// Show Note Table Size % ( default = 80% )
$n->ShowNote_table_size = 80;

/*
 * Database:
 * ---------
 * The notes table should have six columns:
 *
 *    username     char  /  primary
 *    keynum       int   /  key  as mktime()  UNIX TIME
 *    date         char  /  update strings
 *    size         int   /  size as strlen(titel)+strlen(note)
 *    title        char  /  title
 *    note         char  /  note data
 *
 *   CREATE TABLE "notes" (
 *      "username" varchar(128) NOT NULL,
 *      "keynum"   integer      NOT NULL,
 *      "date"     varchar(32)  NOT NULL,
 *      "size"     integer,
 *      "title"    text,
 *      "note"     text,
 *      CONSTRAINT "notes_pkey" PRIMARY KEY ("keynum", "username")
 *   );
 */

$n->notes_dsn = 'pgsql://squirreluser:sqpassword@localhost/squirrelmail' ;
$n->note_table = 'notes' ;

define('SMDB_UNKNOWN', 0);
define('SMDB_MYSQL', 1);
define('SMDB_PGSQL', 2);

?>