<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://advcs.org
    Program ........ Notes
    Version ........ 0.7
    Purpose ........ Storing Notes

*******************************************************************************/


$n = new Notes;
/* Path for SquirrelMail required files. */

chdir("..");
if (!defined('SM_PATH'))
   define('SM_PATH','../');

if (file_exists(SM_PATH . 'include/validate.php')) {
   include_once(SM_PATH . 'include/validate.php');
} else {
   if (file_exists(SM_PATH . 'src/validate.php'))
      include_once(SM_PATH . 'src/validate.php');
}

include_once(SM_PATH . "plugins/notes/config.php");

if (function_exists('sqgetGlobalVar')) {
   sqgetGlobalVar('submit', $submit);
   sqgetGlobalVar('title', $title);
   sqgetGlobalVar('note', $note);
   sqgetGlobalVar('view', $view);
   sqgetGlobalVar('edit', $edit);
   sqgetGlobalVar('delete', $delete);
   sqgetGlobalVar('editnote', $editnote);
} else {
   $submit = sqextractGlobalVar('submit');
   $title = sqextractGlobalVar('title');
   $note = sqextractGlobalVar('note');
   $view = sqextractGlobalVar('view');
   $edit = sqextractGlobalVar('edit');
   $delete = sqextractGlobalVar('delete');
   $editnote = sqextractGlobalVar('editnote');
}

if ($submit != '')
   $submit = strip_tags($submit);
if ($title != '')
   $title = strip_tags($title);
if ($note != '')
   $note = strip_tags($note);
if ($view != '')
   $view = strip_tags($view);
if ($edit != '')
   $edit = strip_tags($edit);
if ($delete != '')
   $delete = strip_tags($delete);
if ($editnote != '')
   $editnote = strip_tags($editnote);

$n->Init();

if ($delete != ""){
   $n->Delete($delete);
   header("Location: notes.php");
}

if ($submit == 'Խ¸' && $n->error < 3){
   $n->Save($editnote, $title, $note);
   header("Location: notes.php");
}

if ($submit == '¸'){
   $n->Add($title, $note);
   header("Location: notes.php");
}

displayPageHeader($color, "None");

if ($edit != '')
   $n->EditNote($edit);

if ($submit == 'Խ¸')
   $submit = '';

if ($submit == 'view')
   $n->ShowNote($view);

if ($submit == '') {
   $n->DisplayList();
}  else if ($submit == 'ɲ'){
   $n->ShowAdd();
}

class Notes {

   var $totalnotes = 0;
   var $maxnotescount = 0;
   var $maxnotesize = 0;
   var $maxnotessize = 0;
   var $error = 0;
   var $file = "";
   var $filesize = 0;
   var $rfilesize = 0;
   var $notes = array();
   var $hashed_dir = '';

   function Init() {
      global $data_dir, $username;
      $this->hashed_dir = getHashedDir($username, $data_dir);
      if (!file_exists("$this->hashed_dir/$username.notes")){
         $file = @fopen("$this->hashed_dir/$username.notes",w);
         fclose($file);
      }
      clearstatcache();
      $this->File();
      $this->FileSize();
      $this->GetNotes();
      $this->TotalNotes();
      $this->TotalSize();
      $this->CheckforErrors();
   }

   function Add($title = "(No Title)", $note = "(No Note)") {
      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $this->notes[$this->notescount]= $date . "|NOTES|" . $title . "|NOTES|" . $note;
      $file = @fopen($this->file,w);
      $this->WriteNotes();
   }

   function Delete($num) {
      $this->notes[$num] = "";
      $this->WriteNotes();
   }

   function Save($editnote, $title = '(No Title)', $note = '(No Note)') {
      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
      $title = str_replace("|NOTES|","[NOTES]",$title);
      $note = str_replace("|NOTES|","[NOTES]",$note);   
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $this->notes[$editnote]= $date . "|NOTES|" . $title . "|NOTES|" . $note;
      $this->WriteNotes();
   }

   function File() {
      global $username;
//      $this->file = "$this->hashed_dir\$username.notes";
      $this->file = "$this->hashed_dir/$username.notes";
   }

   function FileSize() {
      $this->filesize = @filesize($this->file);
   }

   function GetNotes() {
      $file = @fopen($this->file,r);
      $notes = @fread($file ,$this->filesize);
      @fclose($file);
      $this->notes = explode("\n", $notes);
   }

   function TotalSize() {
      $this->size = $this->filesize - ($this->notescount * 15);
   }

   function TotalNotes() {
      $this->notescount = count($this->notes);
      $this->notescount--;
   }

   function WriteNotes() {
      $this->TotalNotes();
      $file = @fopen($this->file,w);
      $count=-1;
      while ($count < $this->notescount){
         $count++;
         if ($this->notes[$count] != '')
            @fputs($file, $this->notes[$count] . "\n");
      }
      @fclose($file);
   }

   function ShowNote ($view) {
      global $color;
      $note = explode("|NOTES|", $this->notes[$view]);
      $date = $note[0];   $title = $note[1];  $text = $note[2];
      $table_size = 80;
      if ( isset($this->ShowNote_table_size) ) {
        $table_size = $this->ShowNote_table_size ;
      }
      print "<br><br><center>
             <table width=\"" .$table_size. "%\" border=1 bgcolor='$color[9]'><tr><td>\n";
      print "<table width=\"100%\"><tr>
               <td align=left><a href='notes.php?edit=$view'>Խ</a></td>
               <td align=right><a href='notes.php?delete=$view'></a></td>
               </tr></table>\n";
      print "<table width=\"100%\" bgcolor='$color[4]'>
             <tr><td>" . htmlspecialchars($title) . "</td></tr>\n";
      print "<tr><td>" . htmlspecialchars($date) .  "</td></tr>\n";
      print "<tr><td><hr width='100%' color='$color[9]'></td></tr>\n";

      $text = str_replace("<br>","\n", $text);
      $text = htmlspecialchars($text) ;
      $text = nl2br ( $text ) ;

      print "<tr><td><br>" . $text ."</td></tr></table>\n";
      print "</td></tr></table></center>\n";
   }

   function DisplayError () {
      if ($this->error == 5)
         print "<center>祵(".sprintf("%01.1f",$this->size/1024)."kB)ĶƤޤ</center>\n";
      if ($this->error == 6)
         print "<center>祵(".sprintf("%01.1f",$this->size/1024)."kB)ĶƤޤ</center>\n";
      if ($this->error == 7)
         print "<center>祵(".sprintf("%01.1f",$this->size/1024)."kB)ĶƤޤ</center>\n";
   }

   function CheckforErrors() {
      global $submit, $title, $note, $edit, $editnote;
      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
         $olddate = '';  $oldtitle = '';   $oldtext = '';
      if (isset($edit)) {
         $oldnote = explode("|NOTES|", $this->notes[$edit]);
         $olddate = $oldnote[0]; $oldtitle = $oldnote[1];  $oldtext = $oldnote[2];
      }
      if ($this->notescount > $this->maxnotescount-1)
         $this->error=2;
      if ($this->maxnotessize > 0 && $this->maxnotessize < $this->size)
         $this->error = 4;
      if ($this->maxnotessize > 0 &&
          $this->maxnotessize < ($this->size + strlen($title . $date . $note)) &&
          $submit == '¸')
         $this->error = 5;
      if ($this->maxnotesize > 0 &&
          $this->maxnotesize < strlen($title . $date . $note))
         $this->error = 6;
      if ($this->maxnotessize > 0 && 
          $this->maxnotessize < ($this->size + strlen($title . $date . $note) - strlen($oldtitle . $olddate . $oldtext)) &&
          $submit == 'Խ¸')
         $this->error = 7;
      if (($submit == '¸' || $submit == 'ɲ') &&
          ($this->error == 1 || $this->error == 2))
         $submit = '';
      if ($submit == 'ɲ' && $this->error == 4)
         $submit = '';
      if ($submit == '¸' && ($this->error == 5 || $this->error == 6))
        $submit = "ɲ";
      if ($editnote != '' && ($this->error == 5 || $this->error == 6)){
        $edit = $editnote;
        $submit = '';
      }
   }

   function EditNote($edit) {
      global $submit, $note, $title, $date;
      print "<h3><center>Խ</center></h3>\n";
      if ($this->error != 6 && $this->error != 5) {
         $note = explode("|NOTES|", $this->notes[$edit]);
         $date = $note[0];  $title = $note[1];  $text = $note[2];
      } else {
         $text = $note;
      }
      $title = str_replace("<br>","\n",$title);
      $text = str_replace("<br>","\n",$text);
      $this->DisplayError();
      print "<form method=post><center><table><tr><td>" ;
      $title_rows = 30 ;  $title_maxlength = 30;
      if ( isset($this->edit_title_rows) && isset($this->edit_title_maxlength) ) {
        $title_rows = $this->edit_title_rows ;
        $title_maxlength = $this->edit_title_maxlength;
      }
      print "<input type=text name=title value='$title' SIZE='$title_rows' MAXLENGTH='$title_maxlength'>" ;
      print "</td></tr>\n";
      $textarea_rows = 8 ;  $textarea_cols = 50 ;
      if ( isset($this->edit_textarea_rows) && isset($this->edit_textarea_cols) ) {
        $textarea_rows = $this->edit_textarea_rows ;
        $textarea_cols = $this->edit_textarea_cols ;
      }
      print "<tr><td>
              <TEXTAREA NAME=note ROWS='$textarea_rows' COLS='$textarea_cols'>$text</TEXTAREA>
             </td></tr>\n";
      print "<tr><td><input type=hidden name=editnote value='$edit'>
                     <input type=hidden name=date value='$date'>
                     <input type=submit name=submit value='Խ¸'></td></tr>\n";
      print "</table></center></form>\n";
      $submit = "editting";
   }

   function DisplayList() {
      global $color;
      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
      print "\n<br><br><center>
        <table width=\"95%\" border=1 bordercolor='$color[10]' bgcolor='$color[9]'>
        <tr><td width=120><center></center></td>
            <td colspan=2 width=350><center>ȥ</center></td>
            <td><center></center></td><td width=90>&nbsp;</td></tr>\n";
      $count = 0;
      while ($count <> $this->notescount){
         $note = explode("|NOTES|", $this->notes[$count]);
         $date = $note[0];
         $title = $note[1];
         $notesize = sprintf("%01.2f", (strlen($this->notes[$count])-14)/1024) ;
         //$notesize = (strlen($this->notes[$count])-14)/1024 ;

         print "<tr bgcolor='$color[4]'>
                   <td bgcolor='$color[4]'><SMALL>&nbsp;$date</SMALL></td>
                   <td colspan=2 bgcolor='$color[4]'>&nbsp;
                      <a href='notes.php?submit=view&view=$count'>$title</a></td>
                   <td bgcolor='$color[4]' align=right><SMALL>$notesize kB</SMALL></td>
                   <td bgcolor='$color[4]'><center><SMALL>
                     <a href='notes.php?edit=$count'>Խ</a> | 
                     <a href='notes.php?delete=$count'></a></SMALL></center>
                   </td></tr>\n";
         $count++;
      }
      if ($this->notescount == 0)
         print "<tr><td colspan=5 bgcolor='$color[4]'>
                      <center>Ϥޤ</center></td></tr>\n";
      $file = @fopen($this->file,r);
      @fclose($file);

      if ($this->maxnotessize > 0) {
         $total_size = sprintf("%01.1f",$this->size/1024)." / " .
                       sprintf("%01.1f",$this->maxnotessize/1024)." kB" ;
         print "<tr>
                 <td><center><SMALL>
                     $this->notescount / $this->maxnotescount 
                 </SMALL></center></td>
                 <td colspan=2>&nbsp;</td>
                 <td><center><SMALL>$total_size</SMALL></center></td>
                 <td>&nbsp;</td></tr>\n";
      }else{
        $total_size = sprintf("%01.1f",$this->size/1024)." kB" ;
         print "<tr>
                 <td><center><SMALL>
                     $this->notescount / $this->maxnotescount 
                 </SMALL></center></td>
                 <td colspan=2>&nbsp;</td>
                 <td><center><SMALL>$total_size</SMALL></center></td>
                  <td>&nbsp;</td></tr>\n";
      }
      print "</table></center><br>\n";
      if ($this->error == 0 && $this->maxnotessize > $this->size)
         print "<center>
                <form><input type=submit name=submit value='ɲ'></form>
                </center>\n";
   }

   function ShowAdd() {
      global $title, $note;
      print "<h3><center>ɲ</center></h3>\n";
      $this->DisplayError();
      if ($title == "")
         $title = "ȥ";
      print "<form method=post><center><table><tr><td>" ;
      $title_rows = 30 ;  $title_maxlength = 30;
      if ( isset($this->edit_title_rows) && isset($this->edit_title_maxlength) ) {
        $title_rows = $this->edit_title_rows ;
        $title_maxlength = $this->edit_title_maxlength;
      }
      print "<input type=text name=title value='$title' SIZE='$title_rows' MAXLENGTH='$title_maxlength'>" ;
      print "</td></tr>\n";
      $textarea_rows = 8 ;  $textarea_cols = 50 ;
      if ( isset($this->edit_textarea_rows) && isset($this->edit_textarea_cols) ) {
        $textarea_rows = $this->edit_textarea_rows ;
        $textarea_cols = $this->edit_textarea_cols ;
      }
      print "<tr><td>
              <TEXTAREA NAME=note ROWS='$textarea_rows' COLS='$textarea_cols'>$note</TEXTAREA>
             </td></tr>\n";
      print "<tr><td>
              <input type=submit name=submit value='¸'>
             </td></tr>\n";
      print "</table></center></form>\n";
   }
}

?>