<?php
/*******************************************************************************

    Author ......... Kiyoshi Sawada
    Contact ........ sawada_k@na.rim.or.jp
    Home Site ...... http://www.na.rim.or.jp/~sawada_k/php/squirrelmail/index.html
    Program ........ NotesDB
    Version ........ 0.71-jp
    Purpose ........ PostgreSQL Storing Notes

*******************************************************************************/

$n = new NotesDB;

/***********************************************************
 Path for SquirrelMail required files.
***********************************************************/
chdir("..");
if (!defined('SM_PATH')) define('SM_PATH','../');

if (file_exists(SM_PATH . 'include/validate.php')) {
   include_once(SM_PATH . 'include/validate.php');
} else {
   if (file_exists(SM_PATH . 'src/validate.php'))
      include_once(SM_PATH . 'src/validate.php');
}

require_once('DB.php');
include_once(SM_PATH . "plugins/notes/config.php");

/***********************************************************
 Global var Check from Get or Post.
***********************************************************/
if (function_exists('sqgetGlobalVar')) {
   sqgetGlobalVar('submit', $submit);
   sqgetGlobalVar('title', $title);
   sqgetGlobalVar('note', $note);
   sqgetGlobalVar('view', $view);
   sqgetGlobalVar('edit', $edit);
   sqgetGlobalVar('delete', $delete);
   sqgetGlobalVar('editnote', $editnote);
} else {
   $submit = sqextractGlobalVar('submit');
   $title = sqextractGlobalVar('title');
   $note = sqextractGlobalVar('note');
   $view = sqextractGlobalVar('view');
   $edit = sqextractGlobalVar('edit');
   $delete = sqextractGlobalVar('delete');
   $editnote = sqextractGlobalVar('editnote');
}

/***********************************************************
 Strip TAGs
***********************************************************/
if ($submit != '')      $submit = strip_tags($submit);
if ($title != '')       $title = strip_tags($title);
if ($note != '')        $note = strip_tags($note);
if ($view != '')        $view = strip_tags($view);
if ($edit != '')        $edit = strip_tags($edit);
if ($delete != '')      $delete = strip_tags($delete);
if ($editnote != '')    $editnote = strip_tags($editnote);

/***********************************************************
 <Main FROM="BGN">
***********************************************************/
					////   $n->Init();
$notesDB_self  = 'notesDB.php' ;
$hed_str = "Location: " . $notesDB_self ;

$n->GetAll();
$n->CheckforErrors();

if ($delete != ""){
   $n->Delete($delete);
   header($hed_str);
}

if ($submit == 'Խ¸' && $n->error < 3){
   $n->Save($editnote, $title, $note);
   header($hed_str);
}

if ($submit == '¸'){
   $n->Add($title, $note);
   header($hed_str);
}

displayPageHeader($color, "None");

if ($edit != '')                 $n->EditNote($edit);
if ($submit == 'Խ¸')     $submit = '';
if ($submit == 'view')           $n->ShowNote($view);
if ($submit == '') {
  $n->DisplayList();
}else if ($submit == 'ɲ') {
  $n->ShowAdd();
}

/***********************************************************
 <Main TO="END">
***********************************************************/

class NotesDB {
   var $notes = array();     var $totalnotes = 0;
   var $maxnotescount = 0;   var $maxnotesize = 0;    var $maxnotessize = 0;

   var $file = "";           var $filesize = 0;       var $rfilesize = 0;

   var $username_field = 'username';     var $keynum_field   = 'keynum';
   var $date_field     = 'date';         var $size_field     = 'size';
   var $title_field    = 'title';        var $note_field     = 'note';

   var $dbh   = NULL;       var $error = NULL;        var $db_type = SMDB_UNKNOWN;

   function Open() {						// DB Open
     if(isset($this->dbh)) return true;
     $dbh = DB::connect($this->notes_dsn);
     if(DB::isError($dbh)) {
       $this->error = DB::errorMessage($dbh);
       return false;
     }
     $this->dbh = $dbh;
     return true;
   }

   function Add($title="(No Title)", $note="(No Note)") {	// Add a New Note 
     global $username ;

      $date = date("y/m/d H:i");
      $keynum  = time();
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $size = strlen($title)+strlen($note);

      if (!$this->Open()) return false;
      $this->dbh->simpleQuery("BEGIN TRANSACTION");
      $query = sprintf("INSERT INTO %s (%s, %s, %s, %s, %s, %s)
                             VALUES    ('%s', %s, '%s', %s, '%s', '%s')",
                        $this->note_table,
                           $this->username_field,  $this->keynum_field,
                           $this->date_field,      $this->size_field,      
                           $this->title_field,     $this->note_field,
                        $this->dbh->quoteString($username),
                        $this->dbh->quoteString($keynum),
                        $this->dbh->quoteString($date),
                        $this->dbh->quoteString($size),
                        $this->dbh->quoteString($title),
                        $this->dbh->quoteString($note)       ) ;
      $res = $this->dbh->simpleQuery($query);
      if (DB::isError($res)) {
        $this->dbh->simpleQuery("ROLLBACK TRANSACTION");
      }
      $this->dbh->simpleQuery("COMMIT TRANSACTION");
      $this->dbh->disconnect ;
   }

   function Delete($editnote) {					// Delete a Note
      global $username;

      if (!$this->Open()) return false;
      $this->dbh->simpleQuery("BEGIN TRANSACTION");
      $query = sprintf("DELETE FROM %s WHERE %s='%s' AND %s=%s",
                        $this->note_table ,
                             $this->username_field, $username,
                             $this->keynum_field,   $editnote ) ;
      $res = $this->dbh->simpleQuery($query);
      if (DB::isError($res)) {
         $this->dbh->simpleQuery("ROLLBACK TRANSACTION");
      }
      $this->dbh->simpleQuery("COMMIT TRANSACTION");
      $this->dbh->disconnect ;
   }

   function Save($editnote, $title='(No Title)', $note='(No Note)') {	// Save a Note after Edit
      global $username;

      $date = date("y/m/d H:i");
      $keynum  = $editnote;
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $size = strlen($title)+strlen($note);

      if (!$this->Open()) return false;
      $this->dbh->simpleQuery("BEGIN TRANSACTION");

      $query = sprintf("UPDATE %s SET %s='%s', %s=%s, %s='%s', %s='%s' 
                                WHERE %s='%s' AND %s=%s " ,
                        $this->note_table ,
                          $this->date_field   , $this->dbh->quoteString($date) ,
                           $this->size_field  , $this->dbh->quoteString($size) ,
                           $this->title_field , $this->dbh->quoteString($title),
                           $this->note_field  , $this->dbh->quoteString($note) ,
                         $this->username_field, $this->dbh->quoteString($username) ,
                         $this->keynum_field  , $this->dbh->quoteString($keynum)    ) ;
      $res = $this->dbh->simpleQuery($query);
      if (DB::isError($res)) {
        $this->dbh->simpleQuery("ROLLBACK TRANSACTION");
      }
      $this->dbh->simpleQuery("COMMIT TRANSACTION");
      $this->dbh->disconnect ;
   }

   function GetAll() {
      global $username;

      if (!$this->Open()) return false;
      $query = sprintf("SELECT %s,%s,%s,%s,%s FROM %s WHERE %s='%s' " ,
                         $this->keynum_field    ,
                           $this->date_field    ,  $this->size_field    ,
                           $this->title_field   ,  $this->note_field    ,
                        $this->note_table ,
                        $this->username_field, $this->dbh->quoteString($username) ) ;
      $this->notes = $this->dbh->getAssoc($query);

      // Notes Count TotalNotes()
      $this->notescount = count($this->notes) ;
      ///$this->notescount--;

      // Total Size
      $this->filesize = 0 ;
      foreach ($this->notes as $line) {
        $this->filesize += $line[1] ;
      }
      $this->size = $this->filesize - ($this->notescount * 15);
      $this->dbh->disconnect ;
   }

   function DisplayError () {
      if ($this->error == 2)
         print "<center>(" .$this->maxnotescount.
               "Ķ¸Ǥޤ</center>\n";
      if ($this->error == 5)
         print "<center>祵(".
               sprintf("%01.1f",$this->size/1024).
               "kB)ĶƤޤ</center>\n";
      if ($this->error == 6)
         print "<center>Υ(".
               sprintf("%01.1f",$this->size/1024).
               "kB)ĶƤޤ</center>\n";
      if ($this->error == 7)
         print "<center>祵(".
               sprintf("%01.1f",$this->size/1024).
               "kB)ĶƤޤ</center>\n";
   }

   function CheckforErrors() {
      global $submit, $title, $note, $edit, $editnote;
      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
      $olddate = ''; $oldsize = ''; $oldtitle = '';   $oldtext = '';
      if (isset($edit)) {
         $oldnote = $this->notes[$edit];
         $olddate = $oldnote[0];  $oldsize = $note[1]; $oldtitle = $oldnote[2];  $oldtext = $oldnote[3];
      }
      if ($this->notescount > $this->maxnotescount-1)                    $this->error=2;
      if ($this->maxnotessize > 0 && $this->maxnotessize < $this->size)  $this->error=4;
      if ($this->maxnotessize > 0 &&
          $this->maxnotessize < ($this->size + strlen($title . $date . $note)) &&
          $submit == '¸')                                             $this->error = 5;
      if ($this->maxnotesize > 0 && $this->maxnotesize < strlen($title . $date . $note))
                                                                         $this->error = 6;
      if ($this->maxnotessize > 0 && 
          $this->maxnotessize < ($this->size + strlen($title . $date . $note) - strlen($oldtitle . $olddate . $oldtext)) &&
          $submit == 'Խ¸')                                       $this->error = 7;
      if (($submit == '¸' || $submit == 'ɲ') && ($this->error == 1 || $this->error == 2))
                                                                          $submit = '';
      if ($submit == 'ɲ' && $this->error == 4)                         $submit = '';
      if ($submit == '¸' && ($this->error == 5 || $this->error == 6))  $submit = "ɲ";
      if ($editnote != '' && ($this->error == 5 || $this->error == 6)){
        $edit = $editnote;
        $submit = '';
      }
   }

   function ShowNote ($view) {
      global $username, $color, $notesDB_self ;

      $note = $this->notes[$view] ;
      $date = $note[0]; $size = $note[1];  $title = $note[2];  $text = $note[3];
 
      $table_size = 80;
      if ( isset($this->ShowNote_table_size) ) {
        $table_size = $this->ShowNote_table_size ;
      }
      print "<br><br><center>
             <table width=\"" .$table_size. "%\" border=1 bgcolor='$color[9]'><tr><td>\n";
      print "<table width=\"100%\"><tr>
               <td align=left><a href='" . $notesDB_self ."?edit=$view'>Խ</a></td>
               <td align=right><a href='" . $notesDB_self ."?delete=$view'></a></td>
               </tr></table>\n";
      print "<table width=\"100%\" bgcolor='$color[4]'>
             <tr><td>" . htmlspecialchars($title) . "</td></tr>\n";
      print "<tr><td>" . htmlspecialchars($date) .  "</td></tr>\n";
      print "<tr><td><hr width='100%' color='$color[9]'></td></tr>\n";

      $text = str_replace("<br>","\n", $text);
      $text = htmlspecialchars($text) ;
      $text = nl2br ( $text ) ;

      print "<tr><td><br>" . $text ."</td></tr></table>\n";
      print "</td></tr></table></center>\n";
   }

   function EditNote($edit) {
      global $submit, $note, $title, $date;
      global $username, $color, $notesDB_self ;

      print "<h3><center>Խ</center></h3>\n";

      if ($this->error != 6 && $this->error != 5) {
         $note = $this->notes[$edit] ;
         $date = $note[0]; $size = $note[1];  $title = $note[2];  $text = $note[3];
      } else {
         $text = $note;
      }

      $title = str_replace("<br>","\n",$title);
      $text = str_replace("<br>","\n",$text);
      $this->DisplayError();
      print "<form method='post' ACTION='$notesDB_self'><center><table><tr><td>" ;
      $title_rows = 30 ;  $title_maxlength = 30;
      if ( isset($this->edit_title_rows) && isset($this->edit_title_maxlength) ) {
        $title_rows = $this->edit_title_rows ;
        $title_maxlength = $this->edit_title_maxlength;
      }
      print "<input type=text name=title value='$title' SIZE='$title_rows' MAXLENGTH='$title_maxlength'>" ;
      print "</td></tr>\n";
      $textarea_rows = 8 ;  $textarea_cols = 50 ;
      if ( isset($this->edit_textarea_rows) && isset($this->edit_textarea_cols) ) {
        $textarea_rows = $this->edit_textarea_rows ;
        $textarea_cols = $this->edit_textarea_cols ;
      }
      print "<tr><td>
              <TEXTAREA NAME=note ROWS='$textarea_rows' COLS='$textarea_cols'>$text</TEXTAREA>
             </td></tr>\n";
      print "<tr><td><input type=hidden name=editnote value='$edit'>
                     <input type=hidden name=date value='$date'>
                     <input type=submit name=submit value='Խ¸'></td></tr>\n";
      print "</table></center></form>\n";
      $submit = "editting";
   }

   function DisplayList() {
      global $username, $color, $notesDB_self ;

      //$date = date("F j, Y");
      $date = date("y/m/d H:i");
      print "\n<br><br><center>
        <table width=\"95%\" border=1 bordercolor='$color[10]' bgcolor='$color[9]'>
        <tr><td width=120><center></center></td>
            <td colspan=2 width=350><center>ȥ</center></td>
            <td><center></center></td><td width=90>&nbsp;</td></tr>\n";
      $count = 0;
      foreach ($this->notes as $keynum => $note){
         $date = $note[0];    $size = $note[1];   $title = $note[2];
         $notesize = sprintf("%01.2f",$size/1024) ;

         print "<tr bgcolor='$color[4]'>
                   <td bgcolor='$color[4]'><SMALL>&nbsp;$date</SMALL></td>
                   <td colspan=2 bgcolor='$color[4]'>&nbsp;
                      <a href='" . $notesDB_self ."?submit=view&view=$keynum'>$title</a></td>
                   <td bgcolor='$color[4]' align=right><SMALL>$notesize kB</SMALL></td>
                   <td bgcolor='$color[4]'><center><SMALL>
                     <a href='" . $notesDB_self ."?edit=$keynum'>Խ</a> | 
                     <a href='" . $notesDB_self ."?delete=$keynum'></a></SMALL></center>
                   </td></tr>\n";
         $count++;
      }
      if ($this->notescount == 0)
         print "<tr><td colspan=5 bgcolor='$color[4]'>
                      <center>Ϥޤ</center></td></tr>\n";

      if ($this->maxnotessize > 0) {
         $total_size = sprintf("%01.1f",$this->size/1024)." / " .
                       sprintf("%01.1f",$this->maxnotessize/1024)." kB" ;
         print "<tr>
                 <td><center><SMALL>$this->notescount / $this->maxnotescount 
                 </SMALL></center></td>
                 <td colspan=2>&nbsp;</td>
                 <td><center><SMALL>$total_size</SMALL></center></td>
                 <td>&nbsp;</td></tr>\n";
      }else{
        $total_size = sprintf("%01.1f",$this->size/1024)." kB" ;
         print "<tr>
                 <td><center><SMALL>
                     $this->notescount / $this->maxnotescount 
                 </SMALL></center></td>
                 <td colspan=2>&nbsp;</td>
                 <td><center><SMALL>$total_size</SMALL></center></td>
                  <td>&nbsp;</td></tr>\n";
      }
      print "</table></center><br>\n";
      if ($this->error == 0 && $this->maxnotessize > $this->size)
         print "<center>
                <form method='post' ACTION='$notesDB_self'>
                <input type=submit name=submit value='ɲ'></form>
                </center>\n";
   }

   function ShowAdd() {
      global $username, $color, $notesDB_self ;
      global $title, $note;

      print "<h3><center>ɲ</center></h3>\n";
      $this->DisplayError();
      if ($title == "") $title = "ȥ";
      print "<form method='post' ACTION='$notesDB_self'><center><table><tr><td>" ;

      $title_rows = 30 ;  $title_maxlength = 30;
      if ( isset($this->edit_title_rows) && isset($this->edit_title_maxlength) ) {
        $title_rows = $this->edit_title_rows ;
        $title_maxlength = $this->edit_title_maxlength;
      }
      print "<input type=text name=title value='$title' SIZE='$title_rows' MAXLENGTH='$title_maxlength'>" ;
      print "</td></tr>\n";
      $textarea_rows = 8 ;  $textarea_cols = 50 ;
      if ( isset($this->edit_textarea_rows) && isset($this->edit_textarea_cols) ) {
        $textarea_rows = $this->edit_textarea_rows ;
        $textarea_cols = $this->edit_textarea_cols ;
      }
      print "<tr><td>
              <TEXTAREA NAME=note ROWS='$textarea_rows' COLS='$textarea_cols'>$note</TEXTAREA>
             </td></tr>\n";
      print "<tr><td>
              <input type=submit name=submit value='¸'>
             </td></tr>\n";
      print "</table></center></form>\n";
   }
}

?>